/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.phantoms_utilities.items;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartHelper;
import appeng.api.util.AEColor;
import appeng.blockentity.networking.CableBusBlockEntity;
import dev.wp.phantoms_utilities.PUConfig;
import dev.wp.phantoms_utilities.PUItems;
import dev.wp.phantoms_utilities.PUSounds;
import dev.wp.phantoms_utilities.Util.PUColor;
import dev.wp.phantoms_utilities.Util.Utils;
import dev.wp.phantoms_utilities.helpers.IMouseWheelItem;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SprayCan
extends Item
implements IMouseWheelItem {
    public SprayCan(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    private static void floodFillCables(Level level, BlockPos startPos, AEColor newColor, Direction side, Player player) {
        int maxTotalChecks = PUConfig.maxTotalChecks;
        int maxBlocks = PUConfig.maxCableDyeCount;
        IPart iPart = PartHelper.getPart((BlockGetter)level, (BlockPos)startPos, null);
        if (!(iPart instanceof IPart)) {
            return;
        }
        IPart origPart = iPart;
        IPartItem originalCable = origPart.getPartItem();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(startPos);
        int currTotalChecks = 0;
        int currBlocks = 0;
        while (!queue.isEmpty() && currTotalChecks < maxTotalChecks) {
            ++currTotalChecks;
            BlockPos currentPos = (BlockPos)queue.poll();
            if (visited.contains(currentPos) || !Utils.mayBreakBlock(level, currentPos, level.getBlockState(currentPos), player)) continue;
            visited.add(currentPos);
            if (!SprayCan.processCablePos(level, currentPos, side, newColor, originalCable, player)) continue;
            if (++currBlocks >= maxBlocks) {
                SprayCan.informPlayer(player, "Max dyeing limit (" + maxBlocks + ") reached, stopping.");
                break;
            }
            for (Direction dir : Direction.values()) {
                queue.add(currentPos.relative(dir));
            }
        }
    }

    private static boolean processCablePos(Level level, BlockPos pos, Direction side, AEColor newColor, IPartItem<?> originalCable, Player player) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof IColorableBlockEntity)) {
            return false;
        }
        IColorableBlockEntity cableBusBE = (IColorableBlockEntity)be;
        IPart iPart = PartHelper.getPart((BlockGetter)level, (BlockPos)pos, null);
        if (!(iPart instanceof IPart)) {
            return false;
        }
        IPart part = iPart;
        IPartItem candidateCable = part.getPartItem();
        if (candidateCable == null || !candidateCable.equals(originalCable)) {
            return false;
        }
        cableBusBE.recolourBlock(side, newColor, player);
        return true;
    }

    private static void floodFillBlocks(Level level, BlockPos startPos, BlockState originalState, BlockState newState, Player player) {
        int maxTotalChecks = PUConfig.maxTotalChecks;
        int maxBlocks = PUConfig.maxBlockDyeCount;
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(startPos);
        int currTotalChecks = 0;
        int currBlocks = 0;
        while (!queue.isEmpty() && currTotalChecks < maxTotalChecks) {
            ++currTotalChecks;
            BlockPos currentPos = (BlockPos)queue.poll();
            if (visited.contains(currentPos) || !Utils.mayBreakBlock(level, currentPos, level.getBlockState(currentPos), player)) continue;
            visited.add(currentPos);
            if (!SprayCan.processBlockPos(level, currentPos, originalState, newState)) continue;
            if (++currBlocks >= maxBlocks) {
                SprayCan.informPlayer(player, "Max dyeing limit (" + maxBlocks + ") reached, stopping.");
                break;
            }
            for (Direction dir : Direction.values()) {
                queue.add(currentPos.relative(dir));
            }
        }
    }

    private static boolean processBlockPos(Level level, BlockPos pos, BlockState originalState, BlockState newState) {
        BlockState currentState = level.getBlockState(pos);
        if (!currentState.equals(originalState)) {
            return false;
        }
        level.setBlockAndUpdate(pos, newState);
        return true;
    }

    private static void playSound(Player player, BlockPos pos, SoundEvent sound, Level level) {
        if (player != null) {
            level.playSound(player, pos, sound, player.getSoundSource(), 1.0f, 1.0f);
        }
    }

    private static AEColor getAEColor(PUColor color) {
        return color == PUColor.CLEAR ? AEColor.TRANSPARENT : AEColor.valueOf((String)color.name());
    }

    private static void informPlayer(Player player, String message) {
        if (player != null) {
            player.displayClientMessage((Component)Component.literal((String)message), false);
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity blockEntity;
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        Direction side = ctx.getClickedFace();
        if (Utils.isAE2Loaded && (blockEntity = level.getBlockEntity(pos)) instanceof IColorableBlockEntity) {
            IColorableBlockEntity colorableBlock = (IColorableBlockEntity)blockEntity;
            return this.paintCables(level, pos, this.getActiveColor(stack), side, player, colorableBlock);
        }
        return this.paintBlocks(level, pos, this.getActiveColor(stack), player);
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        DyeColor color = this.getColor((ItemStack)stack).dye;
        if (color != null && target instanceof Sheep) {
            Sheep sheep = (Sheep)target;
            if (sheep.isAlive() && !sheep.isSheared() && sheep.getColor() != color) {
                sheep.setColor(color);
                sheep.level().playSound(player, (Entity)sheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    private InteractionResult paintCables(Level level, BlockPos pos, PUColor color, Direction side, Player player, IColorableBlockEntity colorableBlock) {
        AEColor aeColor = SprayCan.getAEColor(color);
        if (colorableBlock.getColor() == aeColor) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide()) {
            if (player.isShiftKeyDown() && colorableBlock instanceof CableBusBlockEntity) {
                SprayCan.floodFillCables(level, pos, aeColor, side, player);
            } else {
                colorableBlock.recolourBlock(side, aeColor, player);
            }
        }
        SprayCan.playSound(player, pos, PUSounds.SPRAY_CAN_SPRAY, level);
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
    }

    private InteractionResult paintBlocks(Level level, BlockPos pos, PUColor color, Player player) {
        BlockState originalState = level.getBlockState(pos);
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)originalState.getBlock());
        if (color == PUColor.CLEAR) {
            return InteractionResult.PASS;
        }
        ResourceLocation toBeId = Utils.getRecoloredBlockID(blockId, color);
        if (blockId.equals((Object)toBeId)) {
            return InteractionResult.PASS;
        }
        if (BuiltInRegistries.BLOCK.containsKey(toBeId)) {
            Block newBlock = (Block)BuiltInRegistries.BLOCK.get(toBeId);
            BlockState newState = newBlock.defaultBlockState();
            for (Property property : originalState.getProperties()) {
                newState = Utils.copyProperties(originalState, newState, property);
            }
            if (!level.isClientSide()) {
                if (player.isShiftKeyDown()) {
                    SprayCan.floodFillBlocks(level, pos, originalState, newState, player);
                } else {
                    level.setBlockAndUpdate(pos, newState);
                }
            }
            SprayCan.playSound(player, pos, PUSounds.SPRAY_CAN_SPRAY, level);
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        SprayCan.informPlayer(player, "No block found with ID: " + String.valueOf(toBeId));
        return InteractionResult.FAIL;
    }

    public void cycleColors(ItemStack stack, @Nullable PUColor currColor, Boolean forward) {
        int colorCount = PUColor.VALID_COLORS.size();
        if (currColor == null || currColor == PUColor.CLEAR) {
            if (forward.booleanValue()) {
                this.setColor(stack, PUColor.VALID_COLORS.getFirst());
            } else {
                this.setColor(stack, PUColor.VALID_COLORS.get(colorCount - 1));
            }
            return;
        }
        int index = PUColor.VALID_COLORS.indexOf((Object)currColor);
        if (forward.booleanValue()) {
            if (++index >= colorCount) {
                this.setColor(stack, PUColor.CLEAR);
            } else {
                this.setColor(stack, PUColor.VALID_COLORS.get(index));
            }
        } else if (--index < 0) {
            this.setColor(stack, PUColor.CLEAR);
        } else {
            this.setColor(stack, PUColor.VALID_COLORS.get(index));
        }
    }

    public PUColor getActiveColor(ItemStack stack) {
        return this.getColor(stack);
    }

    public PUColor getColor(ItemStack stack) {
        PUColor selectedColor = (PUColor)((Object)stack.get(PUItems.SELECTED_COLOR));
        if (selectedColor != null) {
            return selectedColor;
        }
        return PUColor.CLEAR;
    }

    private void setColor(ItemStack stack, @Nullable PUColor newColor) {
        stack.set(PUItems.SELECTED_COLOR, (Object)newColor);
    }

    public Component getName(ItemStack stack) {
        MutableComponent extra = Component.empty();
        PUColor color = this.getActiveColor(stack);
        if (color != null && Dist.CLIENT.isClient()) {
            extra = Component.translatable((String)color.translationKey);
        }
        return super.getName(stack).copy().append(" - ").append((Component)extra);
    }

    @Override
    public void onScroll(ItemStack stack, boolean up) {
        this.cycleColors(stack, (PUColor)((Object)stack.get(PUItems.SELECTED_COLOR)), up);
    }

    public void setActiveColor(ItemStack sprayCan, @Nullable PUColor color) {
        if (color == null) {
            this.setColor(sprayCan, PUColor.CLEAR);
            return;
        }
        for (PUColor puColor : PUColor.VALID_COLORS) {
            if (puColor != color) continue;
            this.setColor(sprayCan, color);
            return;
        }
    }
}

