/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.phantoms_utilities;

import dev.wp.phantoms_utilities.PUConfig;
import dev.wp.phantoms_utilities.PUItems;
import dev.wp.phantoms_utilities.PUSounds;
import dev.wp.phantoms_utilities.network.InitNetwork;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="phantoms_utilities")
public class PhantomsUtilities {
    public static final String ID = "phantoms_utilities";
    public static final String NAME = "Phantoms Utilities";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Phantoms Utilities");

    public PhantomsUtilities(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PUConfig.SPEC);
        bus.addListener(this::commonSetup);
        bus.addListener(InitNetwork::init);
        bus.addListener(event -> {
            if (event.getRegistryKey() == Registries.SOUND_EVENT) {
                this.registerSounds();
            }
        });
        this.registerDataComponents();
        PUItems.ITEMS.register(bus);
        PUItems.CREATIVE_MODE_TABS.register(bus);
        PUItems.DATA_COMPONENTS.register(bus);
    }

    public static ResourceLocation makeId(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)id);
    }

    private void registerSounds() {
        PUSounds.register((Registry<SoundEvent>)BuiltInRegistries.SOUND_EVENT);
    }

    private void registerDataComponents() {
        PUItems.DATA_COMPONENTS.register("selected_color", () -> PUItems.SELECTED_COLOR);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }
}

