/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private ResourceLocation location;
    @Unique
    List<SpriteContents> spriteContentsList;

    @Inject(method={"stitch"}, at={@At(value="HEAD")})
    public void stitch(List<SpriteContents> list, int i, Executor executor, CallbackInfoReturnable<SpriteLoader.Preparations> cir) {
        if (this.location.equals((Object)VersionUtil.getMcId("textures/atlas/particles.png"))) {
            this.spriteContentsList = list;
        }
    }

    @ModifyExpressionValue(method={"stitch"}, at={@At(value="NEW", args={"class=net/minecraft/client/renderer/texture/Stitcher"})})
    private Stitcher<SpriteContents> registerWeatherParticleSprites(Stitcher<SpriteContents> stitcher) {
        if (this.location.equals((Object)VersionUtil.getMcId("textures/atlas/particles.png"))) {
            int i;
            int i2;
            NativeImage rainImage = null;
            NativeImage snowImage = null;
            try {
                rainImage = TextureUtil.loadTexture(VersionUtil.getMcId("textures/environment/rain.png"));
                snowImage = TextureUtil.loadTexture(VersionUtil.getMcId("textures/environment/snow.png"));
                TextureUtil.boostAlpha(rainImage, "rain");
                TextureUtil.boostAlpha(snowImage, "snow");
                if (ConfigManager.config.compat.waterTint) {
                    TextureUtil.desaturate(rainImage);
                }
            }
            catch (IOException e) {
                ParticleRain.LOGGER.error("Error loading weather textures: ", (Throwable)e);
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.registerSprite((Stitcher.Entry)TextureUtil.splitImage(rainImage, i2, "rain_"));
            }
            for (i2 = 0; i2 < 4; ++i2) {
                stitcher.registerSprite((Stitcher.Entry)TextureUtil.splitImage(snowImage, i2, "snow_"));
            }
            int rippleResolution = TextureUtil.getRippleResolution(this.spriteContentsList);
            for (i = 0; i < 8; ++i) {
                stitcher.registerSprite((Stitcher.Entry)TextureUtil.generateRipple(i, rippleResolution));
            }
            if (ConfigManager.config.compat.waterTint) {
                for (i = 0; i < 4; ++i) {
                    try {
                        stitcher.registerSprite((Stitcher.Entry)VersionUtil.loadSplashSprite(i));
                        continue;
                    }
                    catch (IOException e) {
                        ParticleRain.LOGGER.error("Error loading splash particle {}: ", (Object)i, (Object)e);
                    }
                }
            }
        }
        return stitcher;
    }
}

