/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config.gui;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import pigcart.particlerain.config.gui.AbstractWidgetAccess;

public class InputWidget
extends EditBox {
    String unformattedValue;
    Function<Object, Component> valueFormatter;
    Pattern filteredChars;
    public static final Pattern NON_INTEGER = Pattern.compile("[^0-9]");
    public static final Pattern NON_FLOAT = Pattern.compile("[^0-9.]");
    public static final Pattern NON_PATH = Pattern.compile("[^a-z0-9:/._-]");
    public static final Pattern NON_HEX = Pattern.compile("[^a-fA-F0-9#]");

    public InputWidget(int width, int x, String initialValue, Consumer<String> onValueChange, Function<Object, Component> valueFormatter) {
        super(Minecraft.getInstance().font, 0, 0, width, 20, (Component)Component.empty());
        ((AbstractWidgetAccess)((Object)this)).particle_rain$setOffset(x);
        this.unformattedValue = initialValue;
        this.valueFormatter = valueFormatter;
        this.setResponder(value -> {
            if (!this.isFocused()) {
                return;
            }
            this.unformattedValue = value;
            try {
                onValueChange.accept((String)value);
                this.setTextColor(0xE0E0E0);
            }
            catch (NumberFormatException ignored) {
                this.setTextColor(-43691);
            }
        });
        this.format();
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.format();
    }

    public void format() {
        if (this.isFocused()) {
            this.forceSetValue(this.unformattedValue);
        } else {
            this.forceSetValue(this.valueFormatter.apply(this.unformattedValue).getString());
        }
    }

    public void forceSetValue(String value) {
        this.value = value;
        this.moveCursorToEnd(false);
        this.setHighlightPos(this.getCursorPosition());
    }

    public void setFilter(Pattern pattern) {
        this.filteredChars = pattern;
        if (this.filteredChars != null) {
            this.setFilter(string -> !this.filteredChars.matcher((CharSequence)string).find());
        } else {
            this.setFilter(Objects::nonNull);
        }
    }
}

