/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particle_effects.mixin;

import com.leclowndu93150.particle_effects.config.ParticleEffectsConfig;
import com.leclowndu93150.particle_effects.manager.ParticleEffectsManager;
import com.leclowndu93150.particle_effects.utils.ArgbUtils;
import com.leclowndu93150.particle_effects.utils.ListUtils;
import com.leclowndu93150.particle_effects.utils.PEType;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.List;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AreaEffectCloud.class})
public abstract class AreaEffectCloudEntityMixin
extends Entity {
    public AreaEffectCloudEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getParticle"})
    private ParticleOptions swapParticleType(ParticleOptions original) {
        if (!((Boolean)ParticleEffectsConfig.CLIENT.modEnabled.get()).booleanValue()) {
            return original;
        }
        if (!(original instanceof ColorParticleOption)) {
            return original;
        }
        ColorParticleOption effect = (ColorParticleOption)original;
        int color = effect.color;
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null || list.isEmpty()) {
            return original;
        }
        ParticleOptions particleEffect = ListUtils.getRandomElement(list, this.level().getRandom());
        if (particleEffect == null) {
            return original;
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        return particleEffect;
    }
}

