/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.oceansdelight.datagen;

import com.scouter.oceansdelight.OceansDelight;
import com.scouter.oceansdelight.items.ODItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class RecipeGenerator
extends RecipeProvider
implements IConditionBuilder {
    public static final int FAST_COOKING = 100;
    public static final int NORMAL_COOKING = 200;
    public static final int SLOW_COOKING = 400;

    public RecipeGenerator(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(pOutput, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ODItems.TENTACLE_ON_A_STICK.get()), (int)1).requires((ItemLike)Items.STICK).requires((ItemLike)ODItems.TENTACLES.get()).unlockedBy("has_tentacles", RecipeGenerator.has((ItemLike)((ItemLike)ODItems.TENTACLES.get()))).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ODItems.CABBAGE_WRAPPED_ELDER_GUARDIAN.get()), (int)1).requires(CommonTags.FOODS_CABBAGE).requires(CommonTags.CROPS_ONION).requires(CommonTags.CROPS_TOMATO).requires((ItemLike)ODItems.COOKED_ELDER_GUARDIAN_SLICE.get()).unlockedBy("has_cooked_elder_guardian_slice", RecipeGenerator.has((ItemLike)((ItemLike)ODItems.COOKED_ELDER_GUARDIAN_SLICE.get()))).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ODItems.STUFFED_COD.get()), (int)1).requires((ItemLike)Items.KELP).requires(CommonTags.CROPS_ONION).requires(CommonTags.CROPS_TOMATO).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)ModItems.ROPE.get()).requires((ItemLike)Items.COD).unlockedBy("has_kelp", RecipeGenerator.has((ItemLike)Items.KELP)).unlockedBy("has_cod", RecipeGenerator.has((ItemLike)Items.COD)).unlockedBy("has_onion", RecipeGenerator.has((TagKey)CommonTags.CROPS_ONION)).unlockedBy("has_brown_mushroom", RecipeGenerator.has((ItemLike)Items.BROWN_MUSHROOM)).unlockedBy("has_rope", RecipeGenerator.has((ItemLike)((ItemLike)ModItems.ROPE.get()))).save(pRecipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ODItems.SEAGRASS_SALAD.get()), (int)1).requires((ItemLike)Items.SEAGRASS).requires((ItemLike)Items.BOWL).unlockedBy("has_seagrass", RecipeGenerator.has((ItemLike)Items.SEAGRASS)).unlockedBy("has_bowl", RecipeGenerator.has((ItemLike)Items.BOWL)).save(pRecipeOutput);
        this.farmersDelightRecipes(pRecipeOutput);
        this.cookMeals(pRecipeOutput);
        this.cuttingAnimalItems(pRecipeOutput);
        this.smeltingRecipes(pRecipeOutput);
    }

    private void farmersDelightRecipes(RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ODItems.ELDER_GUARDIAN_ROLL.get())).requires((ItemLike)ODItems.ELDER_GUARDIAN_SLICE.get(), 2).requires((ItemLike)ModItems.COOKED_RICE.get()).unlockedBy("has_elder_guardian_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ODItems.ELDER_GUARDIAN_SLICE.get()})).save(consumer, OceansDelight.prefix("food/elder_guardian_roll"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ODItems.FUGU_ROLL.get())).requires((ItemLike)ODItems.FUGU_SLICE.get(), 2).requires((ItemLike)ModItems.COOKED_RICE.get()).unlockedBy("has_fugu_slice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ODItems.FUGU_SLICE.get()})).save(consumer, OceansDelight.prefix("food/fugu_roll"));
    }

    private void cookMeals(RecipeOutput consumer) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ODItems.SQUID_RINGS.get()), (int)1, (int)200, (float)0.35f, (ItemLike)Items.BOWL).addIngredient((ItemLike)ODItems.CUT_TENTACLES.get()).addIngredient(CommonTags.FOODS_DOUGH).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(consumer, OceansDelight.prefix("cooking/squid_rings"));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ODItems.HONEY_FRIED_KELP.get()), (int)1, (int)200, (float)0.35f).addIngredient((ItemLike)Items.HONEY_BOTTLE).addIngredient((ItemLike)Items.DRIED_KELP).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(consumer, OceansDelight.prefix("cooking/honey_fried_kelp"));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ODItems.BRAISED_SEA_PICKLE.get()), (int)1, (int)200, (float)0.35f, (ItemLike)Items.BOWL).addIngredient((ItemLike)Items.SEA_PICKLE).addIngredient((ItemLike)Items.BROWN_MUSHROOM).addIngredient((ItemLike)Items.BROWN_MUSHROOM).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(consumer, OceansDelight.prefix("cooking/braised_sea_pickle"));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ODItems.GUARDIAN_SOUP.get()), (int)1, (int)200, (float)0.35f, (ItemLike)Items.BOWL).addIngredient((ItemLike)ODItems.GUARDIAN.get()).addIngredient(CommonTags.CROPS_ONION).addIngredient(CommonTags.FOODS_COOKED_EGG).addIngredient(CommonTags.FOODS_COOKED_EGG).addIngredient(CommonTags.CROPS_TOMATO).addIngredient(CommonTags.CROPS_TOMATO).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).save(consumer, OceansDelight.prefix("cooking/guardian_soup"));
    }

    private void cuttingAnimalItems(RecipeOutput consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.PUFFERFISH}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ODItems.FUGU_SLICE.get()), (int)6).addResult((ItemLike)Items.BONE_MEAL).build(consumer, OceansDelight.prefix("cutting/pufferfish"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ODItems.TENTACLES.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ODItems.CUT_TENTACLES.get()), (int)3).build(consumer, OceansDelight.prefix("cutting/tentacles"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ODItems.GUARDIAN.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ODItems.GUARDIAN_TAIL.get()), (int)1).addResult((ItemLike)Items.BONE_MEAL).build(consumer, OceansDelight.prefix("cutting/guardian"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ODItems.ELDER_GUARDIAN_SLAB.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ODItems.ELDER_GUARDIAN_SLICE.get()), (int)9).addResult((ItemLike)Items.BONE_MEAL).build(consumer, OceansDelight.prefix("cutting/elder_guardian_slab"));
    }

    private void smeltingRecipes(RecipeOutput consumer) {
        RecipeGenerator.foodSmeltingRecipes("cooked_guardian_tail", (ItemLike)ODItems.GUARDIAN_TAIL.get(), (ItemLike)ODItems.COOKED_GUARDIAN_TAIL.get(), 0.45f, consumer);
        RecipeGenerator.foodSmeltingRecipes("cooked_elder_guardian_slice", (ItemLike)ODItems.ELDER_GUARDIAN_SLICE.get(), (ItemLike)ODItems.COOKED_ELDER_GUARDIAN_SLICE.get(), 0.65f, consumer);
        RecipeGenerator.foodSmeltingRecipes("baked_tentacle_on_a_stick", (ItemLike)ODItems.TENTACLE_ON_A_STICK.get(), (ItemLike)ODItems.BAKED_TENTACLE_ON_A_STICK.get(), 0.35f, consumer);
        RecipeGenerator.foodSmeltingRecipes("cooked_stuffed_cod", (ItemLike)ODItems.STUFFED_COD.get(), (ItemLike)ODItems.COOKED_STUFFED_COD.get(), 0.35f, consumer);
    }

    private static void foodSmeltingRecipes(String name, ItemLike ingredient, ItemLike result, float experience, RecipeOutput output) {
        String namePrefix = ResourceLocation.fromNamespaceAndPath((String)"oceansdelight", (String)name).toString();
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)200).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ingredient})).save(output);
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)600).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ingredient})).save(output, namePrefix + "_from_campfire_cooking");
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)100).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ingredient})).save(output, namePrefix + "_from_smoking");
    }
}

