/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BlockEntityUtil {
    public static boolean isLoaded(Level level, GlobalBlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (level.dimension() == pos.getDimensionKey()) {
            return level.isLoaded(pos.getPos());
        }
        if (level.isClientSide) {
            return false;
        }
        ServerLevel dimensionWorld = ServerLifecycleHooks.getCurrentServer().getLevel(pos.getDimensionKey());
        if (dimensionWorld != null) {
            return dimensionWorld.isLoaded(pos.getPos());
        }
        return false;
    }

    public static BlockEntity get(Level level, GlobalBlockPos pos) {
        if (pos == null) {
            return null;
        }
        if (level.dimension() == pos.getDimensionKey()) {
            return BlockEntityUtil.getWorldTileEntityUnchecked(level, pos.getPos());
        }
        if (level.isClientSide) {
            return null;
        }
        ServerLevel dimensionWorld = ServerLifecycleHooks.getCurrentServer().getLevel(pos.getDimensionKey());
        if (dimensionWorld != null) {
            return BlockEntityUtil.getWorldTileEntityUnchecked((Level)dimensionWorld, pos.getPos());
        }
        return null;
    }

    static BlockEntity getWorldTileEntityUnchecked(Level level, BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return null;
        }
        return level.getChunkAt(pos).getBlockEntity(pos, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public static void updateTile(Level level, BlockPos pos) {
        if (level == null || level.isClientSide || !level.isLoaded(pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        level.sendBlockUpdated(pos, state, state, 2);
        level.blockEntityChanged(pos);
    }

    public static <T> boolean hasCapabilityOnAnySide(BlockEntity blockEntity, BlockCapability<T, Direction> capability) {
        for (Direction face : Direction.values()) {
            if (blockEntity.getLevel().getCapability(capability, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)face) == null) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItemWithNbt(Block block, LevelReader level, BlockPos pos) {
        ItemStack itemStack = new ItemStack((ItemLike)block);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            blockEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess());
        } else {
            Occultism.LOGGER.warn("BlockEntity is null for block {} at pos {}, cannot get ItemStack with Components", (Object)block, (Object)pos);
        }
        return itemStack;
    }
}

