/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.registry;

import com.google.common.base.Suppliers;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public enum OccultismTiers implements Tier
{
    SPIRIT_ATTUNED(Tiers.DIAMOND, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, Tiers.STONE.getUses(), 9.0f, 3.0f, 22, () -> Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM})),
    IESNIUM(Tiers.DIAMOND, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1561, 10.0f, 4.0f, 24, () -> Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.IESNIUM_INGOT}));

    private final Tiers vanillaTier;
    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float damage;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;

    private OccultismTiers(Tiers vanillaTier, TagKey<Block> incorrectBlockForDrops, int uses, float speed, float damage, int enchantmentValue, Supplier<Ingredient> repairIngredient) {
        this.vanillaTier = vanillaTier;
        this.incorrectBlocksForDrops = incorrectBlockForDrops;
        this.uses = uses;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    @Nullable
    public TagKey<Block> getTag() {
        return CommonHooks.getTagFromVanillaTier((Tiers)this.vanillaTier);
    }
}

