/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.common.entity.familiar.BeholderFamiliarEntity;
import com.klikli_dev.occultism.network.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class MessageBeholderAttack
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"beholder_attack");
    public static final CustomPacketPayload.Type<MessageBeholderAttack> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageBeholderAttack> STREAM_CODEC = CustomPacketPayload.codec(MessageBeholderAttack::encode, MessageBeholderAttack::new);
    private int beholderId;
    private List<Integer> targetIds;

    public MessageBeholderAttack(int beholderId, List<Integer> targetIds) {
        this.beholderId = beholderId;
        this.targetIds = targetIds;
    }

    public MessageBeholderAttack(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.beholderId);
        buf.writeInt(this.targetIds.size());
        for (int id : this.targetIds) {
            buf.writeInt(id);
        }
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.beholderId = buf.readInt();
        this.targetIds = new ArrayList<Integer>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.targetIds.add(buf.readInt());
        }
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Entity entity = minecraft.level.getEntity(this.beholderId);
        if (entity instanceof BeholderFamiliarEntity) {
            BeholderFamiliarEntity beholder = (BeholderFamiliarEntity)entity;
            beholder.shootRay(this.targetIds);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

