/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.waila;

import com.klikli_dev.occultism.client.misc.ClientPentacleManager;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class SacrificialComponentProvider
implements IBlockComponentProvider {
    public static SacrificialComponentProvider INSTANCE = new SacrificialComponentProvider();

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof GoldenSacrificialBowlBlockEntity) {
            Recipe recipe;
            GoldenSacrificialBowlBlockEntity goldenSacrificialBowlBlockEntity = (GoldenSacrificialBowlBlockEntity)blockEntity;
            if (goldenSacrificialBowlBlockEntity.getCurrentRitualRecipe() != null && (recipe = goldenSacrificialBowlBlockEntity.getCurrentRitualRecipe().value()) instanceof RitualRecipe) {
                RitualRecipe recipe2 = (RitualRecipe)recipe;
                if (goldenSacrificialBowlBlockEntity.ritualActive) {
                    String ritualID = I18n.get((String)("item.occultism.ritual_dummy." + goldenSacrificialBowlBlockEntity.getCurrentRitualRecipe().id().getPath().substring(7)), (Object[])new Object[0]);
                    String ritualName = Component.translatable((String)ritualID).getString();
                    int i = ritualName.indexOf(":");
                    iTooltip.add((Component)Component.translatable((String)"occultism.waila.current_ritual", (Object[])new Object[]{Component.literal((String)ritualName.substring(i + 2)).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.WHITE));
                    if (!goldenSacrificialBowlBlockEntity.sacrificeFulfilled()) {
                        iTooltip.add((Component)Component.translatable((String)"occultism.waila.no_sacrifice").withStyle(ChatFormatting.RED));
                        iTooltip.add((Component)Component.empty().append("-> ").append((Component)Component.translatable((String)recipe2.getEntityToSacrificeDisplayName())).withStyle(ChatFormatting.RED));
                    }
                    if (!goldenSacrificialBowlBlockEntity.itemUseFulfilled()) {
                        ItemStack[] stacks = ((RitualRecipe)goldenSacrificialBowlBlockEntity.currentRitualRecipe.value()).getItemToUse().getItems();
                        int index = stacks.length == 1 ? 0 : (int)(System.currentTimeMillis() / 1000L) % stacks.length;
                        iTooltip.add((Component)Component.translatable((String)"occultism.waila.no_item_use").withStyle(ChatFormatting.RED));
                        iTooltip.add((Component)Component.empty().append("-> ").append((Component)Component.translatable((String)recipe2.getItemToUse().getItems()[index].getDisplayName().getString())).withStyle(ChatFormatting.RED));
                    }
                    return;
                }
            }
            ClientPentacleManager.rebuild(blockAccessor.getPosition());
            if (!ClientPentacleManager.lastPentacles.isEmpty()) {
                iTooltip.add((Component)Component.translatable((String)"hud.occultism.pentacle_found"));
                for (MutableComponent text : ClientPentacleManager.lastPentacles) {
                    iTooltip.add((Component)text);
                }
            } else {
                iTooltip.add((Component)ClientPentacleManager.noPentacleFound.withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"sacrificial");
    }
}

