/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe;

import com.klikli_dev.occultism.datagen.recipe.builders.RitualRecipeBuilder;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRituals;
import com.klikli_dev.occultism.registry.OccultismSpiritJobs;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public abstract class RitualRecipes
extends RecipeProvider {
    private static final ResourceLocation RITUAL_SUMMON = OccultismRituals.SUMMON.getId();
    private static final ResourceLocation RITUAL_SUMMON_WILD = OccultismRituals.SUMMON_WILD.getId();
    private static final ResourceLocation RITUAL_SUMMON_JOB = OccultismRituals.SUMMON_SPIRIT_WITH_JOB.getId();
    private static final ResourceLocation RITUAL_FAMILIAR = OccultismRituals.SUMMON_TAMED.getId();
    private static final ResourceLocation RITUAL_CRAFT_WITH_SPIRIT_NAME = OccultismRituals.CRAFT_WITH_SPIRIT_NAME.getId();
    private static final ResourceLocation RITUAL_CRAFT = OccultismRituals.CRAFT.getId();
    private static final ResourceLocation RITUAL_CRAFT_MINER_SPIRIT = OccultismRituals.CRAFT_MINER_SPIRIT.getId();
    private static final ResourceLocation RITUAL_REPAIR = OccultismRituals.REPAIR.getId();
    private static final ResourceLocation RITUAL_UPGRADE = OccultismRituals.UPGRADE.getId();
    private static final ResourceLocation PENTACLE_SUMMON_FOLIOT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_foliot");
    private static final ResourceLocation PENTACLE_SUMMON_DJINNI = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_djinni");
    private static final ResourceLocation PENTACLE_SUMMON_UNBOUND_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_unbound_afrit");
    private static final ResourceLocation PENTACLE_SUMMON_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_afrit");
    private static final ResourceLocation PENTACLE_SUMMON_UNBOUND_MARID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_unbound_marid");
    private static final ResourceLocation PENTACLE_SUMMON_MARID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"summon_marid");
    private static final ResourceLocation PENTACLE_POSSESS_FOLIOT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_foliot");
    private static final ResourceLocation PENTACLE_POSSESS_DJINNI = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_djinni");
    private static final ResourceLocation PENTACLE_POSSESS_UNBOUND_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_unbound_afrit");
    private static final ResourceLocation PENTACLE_POSSESS_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_afrit");
    private static final ResourceLocation PENTACLE_POSSESS_MARID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"possess_marid");
    private static final ResourceLocation PENTACLE_CRAFT_FOLIOT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_foliot");
    private static final ResourceLocation PENTACLE_CRAFT_DJINNI = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_djinni");
    private static final ResourceLocation PENTACLE_CRAFT_AFRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_afrit");
    private static final ResourceLocation PENTACLE_CRAFT_MARID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"craft_marid");
    private static final ResourceLocation PENTACLE_RESURRECT_SPIRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"resurrect_spirit");
    private static final ResourceLocation PENTACLE_CONTACT_WILD_SPIRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"contact_wild_spirit");
    private static final ResourceLocation PENTACLE_CONTACT_ELDRITCH_SPIRIT = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"contact_eldritch_spirit");

    public RitualRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(p_248933_, lookupProvider);
    }

    private static ItemStack makeLoreSpawnEgg(Item item, String key) {
        ItemStack output = new ItemStack((ItemLike)item);
        output.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)(key + ".tooltip")))));
        output.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)key));
        return output;
    }

    private static ItemStack makeRitualDummy(ItemLike item) {
        return new ItemStack(item);
    }

    private static ItemStack makeRitualDummy(ResourceLocation location) {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(location));
    }

    private static ItemStack makeJeiDummy(ResourceLocation location) {
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(location));
    }

    private static ItemStack makeJeiNoneDummy() {
        return RitualRecipes.makeJeiDummy(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"jei_dummy/none"));
    }

    public static void ritualRecipes(RecipeOutput recipeOutput, HolderLookup.Provider registries) {
        RitualRecipes.summonRituals(recipeOutput);
        RitualRecipes.possessRituals(recipeOutput);
        RitualRecipes.familiarRituals(recipeOutput);
        RitualRecipes.craftingRituals(recipeOutput);
        RitualRecipes.stabilizerRecipes(recipeOutput);
        RitualRecipes.minerRecipes(recipeOutput);
        RitualRecipes.resurrectRituals(recipeOutput);
        RitualRecipes.repairRituals(recipeOutput);
        RitualRecipes.randomRituals(recipeOutput);
        RitualRecipes.contactRituals(recipeOutput);
        RitualRecipes.upgradeRituals(recipeOutput);
    }

    private static void summonRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_AFRIT.get(), "item.occultism.ritual_dummy.summon_afrit_crusher"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_CRUSHER.get()), 180, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of(OccultismTags.Items.IESNIUM_DUST), Ingredient.of(OccultismTags.Items.EMERALD_DUST), Ingredient.of(OccultismTags.Items.LAPIS_DUST), Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.OBSIDIAN_DUST)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier3")).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_AFRIT.get(), "item.occultism.ritual_dummy.summon_afrit_smelter"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_SMELTER.get()), 180, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.RODS_BLAZE), Ingredient.of((TagKey)Tags.Items.BUCKETS_LAVA), Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGMA_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_NETHER_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_CAMPFIRE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelt_tier3")).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_smelter"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_AFRIT.get(), "item.occultism.ritual_dummy.summon_afrit_crystallizer"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_CRYSTALLIZER.get()), 180, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.GRAY_PASTE}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_LAPIS), Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIPSTONE_BLOCK})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystal_tier3")).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_crystallizer"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_AFRIT.get(), "item.occultism.ritual_dummy.summon_afrit_rain_weather"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_RAIN_WEATHER.get()), 90, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.SANDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CACTUS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DEAD_BUSH})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"rain_weather")).entityToSacrifice(OccultismTags.Entities.COWS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_rain_weather"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_AFRIT.get(), "item.occultism.ritual_dummy.summon_afrit_thunder_weather"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_THUNDER_WEATHER.get()), 90, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_AFRIT, Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.AFRIT_TYPE.get()).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"thunder_weather")).entityToSacrifice(OccultismTags.Entities.COWS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_afrit_thunder_weather"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DEMONIC_HUSBAND.get(), "item.occultism.ritual_dummy.summon_demonic_husband"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DEMONIC_HUSBAND.get()), 120, RITUAL_FAMILIAR, PENTACLE_SUMMON_DJINNI, Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((TagKey)ItemTags.SWORDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon(OccultismEntities.DEMONIC_HUSBAND.get()).entityToSacrifice(OccultismTags.Entities.CHICKEN).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_demonic_husband"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DEMONIC_WIFE.get(), "item.occultism.ritual_dummy.summon_demonic_wife"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DEMONIC_WIFE.get()), 120, RITUAL_FAMILIAR, PENTACLE_SUMMON_DJINNI, Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((TagKey)ItemTags.SWORDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon(OccultismEntities.DEMONIC_WIFE.get()).entityToSacrifice(OccultismTags.Entities.CHICKEN).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_demonic_wife"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DJINNI.get(), "item.occultism.ritual_dummy.summon_djinni_crusher"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_CRUSHER.get()), 120, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of(OccultismTags.Items.IRON_DUST), Ingredient.of(OccultismTags.Items.GOLD_DUST), Ingredient.of(OccultismTags.Items.COPPER_DUST), Ingredient.of(OccultismTags.Items.SILVER_DUST)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier2")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DJINNI.get(), "item.occultism.ritual_dummy.summon_djinni_smelter"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_SMELTER.get()), 120, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CHARGE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAST_FURNACE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SMOKER}), Ingredient.of((TagKey)Tags.Items.TOOLS_IGNITER)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelt_tier2")).entityToSummon((EntityType)OccultismEntities.DJINNI_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_smelter"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DJINNI.get(), "item.occultism.ritual_dummy.summon_djinni_crystallizer"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_CRYSTALLIZER.get()), 120, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.GRAY_PASTE}), Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS), Ingredient.of((TagKey)Tags.Items.GEMS_AMETHYST), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystal_tier2")).entityToSummon((EntityType)OccultismEntities.DJINNI_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_crystallizer"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_MANAGE_MACHINE.get()), 120, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COAL), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.FURNACE})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"manage_machine")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_manage_machine"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DJINNI.get(), "item.occultism.ritual_dummy.summon_djinni_gambler"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_GAMBLER.get()), 120, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_SILVER)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(1800).spiritJobType(OccultismSpiritJobs.TRADE_GAMBLER.getId()).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_gambler"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DJINNI.get(), "item.occultism.ritual_dummy.summon_djinni_clear_weather"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_CLEAR_WEATHER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of((TagKey)Tags.Items.CROPS_BEETROOT), Ingredient.of((TagKey)Tags.Items.CROPS_CARROT), Ingredient.of((TagKey)Tags.Items.CROPS_POTATO), Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritMaxAge(15).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"clear_weather")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_clear_weather"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DJINNI.get(), "item.occultism.ritual_dummy.summon_djinni_day_time"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_DAY_TIME.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH}), Ingredient.of((TagKey)ItemTags.SAPLINGS), Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"day_time")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_day_time"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DJINNI.get(), "item.occultism.ritual_dummy.summon_djinni_night_time"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_NIGHT_TIME.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_DJINNI, Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.DYES_BLACK)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"night_time")).entityToSummon(OccultismEntities.DJINNI.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_djinni_night_time"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WONDERING_TRADER.get(), "item.occultism.ritual_dummy.summon_wondering_trader"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_WONDERING_TRADER.get()), 120, RITUAL_SUMMON, PENTACLE_SUMMON_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon(OccultismEntities.WONDERING_TRADER.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_wondering_trader"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_CLEANER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BRUSH.get()}), Ingredient.of((TagKey)Tags.Items.CHESTS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DISPENSER}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.HOPPER})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"cleaner")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_cleaner"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FOLIOT.get(), "item.occultism.ritual_dummy.summon_foliot_crusher"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_CRUSHER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of(OccultismTags.Items.INGOTS_SILVER)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier1")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FOLIOT.get(), "item.occultism.ritual_dummy.summon_foliot_smelter"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_SMELTER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((TagKey)ItemTags.COALS), Ingredient.of((ItemLike[])new ItemLike[]{Items.FURNACE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CAMPFIRE})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelt_tier1")).entityToSummon((EntityType)OccultismEntities.FOLIOT_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_smelter"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FOLIOT.get(), "item.occultism.ritual_dummy.summon_foliot_crystallizer"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_CRYSTALLIZER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL}), Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.LAPIS_DUST), Ingredient.of(OccultismTags.Items.EMERALD_DUST)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystal_tier1")).entityToSummon((EntityType)OccultismEntities.FOLIOT_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_crystallizer"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_LUMBERJACK.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BIRCH_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPRUCE_SAPLING}), Ingredient.of((TagKey)ItemTags.AXES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"lumberjack")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_lumberjack"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_FARMER.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_FARMER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.DATURA}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((TagKey)ItemTags.HOES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"farmer")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_farmer"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FOLIOT.get(), "item.occultism.ritual_dummy.summon_foliot_otherstone_trader"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_OTHERSTONE_TRADER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GRANITE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DIORITE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.ANDESITE})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(3600).spiritJobType(OccultismSpiritJobs.TRADE_OTHERSTONE.getId()).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_otherstone_trader"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FOLIOT.get(), "item.occultism.ritual_dummy.summon_foliot_otherrock_trader"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_OTHERROCK_TRADER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DEEPSLATE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DRIPSTONE_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CALCITE}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.MAGMA_BLOCK})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(3600).spiritJobType(OccultismSpiritJobs.TRADE_OTHERROCK.getId()).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_otherrock_trader"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FOLIOT.get(), "item.occultism.ritual_dummy.summon_foliot_sapling_trader"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_SAPLING_TRADER.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.OAK_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BIRCH_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPRUCE_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.JUNGLE_SAPLING})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(3600).spiritJobType(OccultismSpiritJobs.TRADE_OTHERWORLD_SAPLINGS.getId()).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_sapling_trader"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_TRANSPORT_ITEMS.get()), 60, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.MINECART}), Ingredient.of((TagKey)Tags.Items.CHESTS), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DISPENSER}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.HOPPER})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"transport_items")).entityToSummon(OccultismEntities.FOLIOT.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_foliot_transport_items"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_MARID.get(), "item.occultism.ritual_dummy.summon_marid_crusher"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_MARID_CRUSHER.get()), 240, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_MARID, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_EMERALD), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_NETHERITE), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crush_tier4")).entityToSummon((EntityType)OccultismEntities.MARID_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_marid_crusher"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_MARID.get(), "item.occultism.ritual_dummy.summon_marid_smelter"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_MARID_SMELTER.get()), 240, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_MARID, Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{Items.CRYING_OBSIDIAN}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COAL), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_CAMPFIRE.asItem()})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"smelt_tier4")).entityToSummon((EntityType)OccultismEntities.MARID_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_marid_smelter"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_MARID.get(), "item.occultism.ritual_dummy.summon_marid_crystallizer"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_MARID_CRYSTALLIZER.get()), 240, RITUAL_SUMMON_JOB, PENTACLE_SUMMON_MARID, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.GRAY_PASTE}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{Items.BUDDING_AMETHYST}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SEA_LANTERN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_CATALYST})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).spiritMaxAge(-1).spiritJobType(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystal_tier4")).entityToSummon((EntityType)OccultismEntities.MARID_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_marid_crystallizer"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.AFRIT_ESSENCE.get(), "item.occultism.ritual_dummy.summon_unbound_afrit"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_UNBOUND_AFRIT.get()), 150, RITUAL_SUMMON, PENTACLE_SUMMON_UNBOUND_AFRIT, Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of(OccultismTags.Items.IESNIUM_INGOT), Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.AFRIT_WILD.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").entityToSacrifice(OccultismTags.Entities.COWS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_unbound_afrit"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MARID_ESSENCE.get(), "item.occultism.ritual_dummy.summon_unbound_marid"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_SUMMON_UNBOUND_MARID.get()), 210, RITUAL_SUMMON, PENTACLE_SUMMON_UNBOUND_MARID, Ingredient.of((ItemLike[])new ItemLike[]{Items.CONDUIT}), Ingredient.of((TagKey)Tags.Items.GEMS_PRISMARINE), Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSummon(OccultismEntities.MARID_UNBOUND.get()).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.TRIDENT})).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/summon_unbound_marid"));
    }

    private static void possessRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_ELDER_GUARDIAN.get(), "item.occultism.ritual_dummy.possess_elder_guardian"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_ELDER_GUARDIAN.get()), 90, RITUAL_SUMMON, PENTACLE_POSSESS_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_PRISMARINE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_PRISMARINE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SEA_LANTERN}), Ingredient.of((TagKey)Tags.Items.BUCKETS_WATER), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_ELDER_GUARDIAN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.fish").entityToSacrifice(OccultismTags.Entities.FISH).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_elder_guardian"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_HOGLIN.get(), "item.occultism.ritual_dummy.possess_hoglin"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_HOGLIN.get()), 90, RITUAL_SUMMON, PENTACLE_POSSESS_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_HOGLIN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_hoglin"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_SHULKER.get(), "item.occultism.ritual_dummy.possess_shulker"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_SHULKER.get()), 90, RITUAL_SUMMON, PENTACLE_POSSESS_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_GLAZED_TERRACOTTA}), Ingredient.of((TagKey)Tags.Items.END_STONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_GLAZED_TERRACOTTA})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_SHULKER_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cubemob").entityToSacrifice(OccultismTags.Entities.CUBEMOB).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_shulker"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_WARDEN.get(), "item.occultism.ritual_dummy.possess_warden"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_WARDEN.get()), 90, RITUAL_SUMMON, PENTACLE_POSSESS_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").entityToSacrifice(OccultismTags.Entities.COWS).entityToSummon((EntityType)OccultismEntities.POSSESSED_WARDEN_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_warden"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_ZOMBIE_PIGLIN.get(), "item.occultism.ritual_dummy.possess_zombie_piglin"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_ZOMBIE_PIGLIN.get()), 90, RITUAL_SUMMON, PENTACLE_POSSESS_UNBOUND_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.GILDED_BLACKSTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_FUNGUS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_ZOMBIE_PIGLIN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_zombie_piglin"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_GUARDIAN.get(), "item.occultism.ritual_dummy.possess_guardian"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_GUARDIAN.get()), 90, RITUAL_SUMMON, PENTACLE_POSSESS_UNBOUND_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.TROPICAL_FISH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_LAPIS), Ingredient.of((ItemLike[])new ItemLike[]{Items.TURTLE_SCUTE}), Ingredient.of((TagKey)Tags.Items.BUCKETS_WATER)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_GUARDIAN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.fish").entityToSacrifice(OccultismTags.Entities.FISH).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_guardian"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_OTHERWORLD_BIRD.get(), "item.occultism.ritual_dummy.possess_unbound_otherworld_bird"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_UNBOUND_OTHERWORLD_BIRD.get()), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)ItemTags.LEAVES), Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon(OccultismEntities.OTHERWORLD_BIRD.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.parrots").entityToSacrifice(OccultismTags.Entities.PARROTS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_unbound_otherworld_bird"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_ENDERMAN.get(), "item.occultism.ritual_dummy.possess_enderman"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_ENDERMAN.get()), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.END_STONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_ENDERMAN_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_enderman"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_GHAST.get(), "item.occultism.ritual_dummy.possess_ghast"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_GHAST.get()), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS), Ingredient.of(OccultismTags.Items.MAGMA), Ingredient.of((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS), Ingredient.of(OccultismTags.Items.MAGMA), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_GHAST_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").entityToSacrifice(OccultismTags.Entities.COWS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_ghast"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_WEAK_SHULKER.get(), "item.occultism.ritual_dummy.possess_weak_shulker"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_WEAK_SHULKER.get()), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_CONCRETE}), Ingredient.of((TagKey)Tags.Items.END_STONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.PURPLE_CONCRETE})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSacrifice(OccultismTags.Entities.CUBEMOB).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cubemob").entityToSummon((EntityType)OccultismEntities.POSSESSED_WEAK_SHULKER_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_weak_shulker"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.CURSED_HONEY.get(), "item.occultism.ritual_dummy.possess_bee"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_BEE.get()), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB_BLOCK})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_BEE_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").entityToSacrifice(OccultismTags.Entities.CHICKEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_bee"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_BLAZE.get(), "item.occultism.ritual_dummy.possess_blaze"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_BLAZE.get()), 60, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CHARGE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FIREWORK_STAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH}), Ingredient.of((TagKey)ItemTags.CANDLES), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_BLAZE_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").entityToSacrifice(OccultismTags.Entities.CHICKEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_blaze"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.PARROT_SPAWN_EGG, "item.occultism.ritual_dummy.possess_unbound_parrot"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_POSSESS_UNBOUND_PARROT), 30, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.DYES_GREEN), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW), Ingredient.of((TagKey)Tags.Items.DYES_RED), Ingredient.of((TagKey)Tags.Items.DYES_BLUE)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon(EntityType.PARROT).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").entityToSacrifice(OccultismTags.Entities.CHICKEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_unbound_parrot"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_ENDERMITE.get(), "item.occultism.ritual_dummy.possess_endermite"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_ENDERMITE.get()), 30, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)ItemTags.DIRT), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)ItemTags.DIRT), Ingredient.of((TagKey)Tags.Items.STONES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_ENDERMITE_TYPE.get()).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_endermite"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_PHANTOM.get(), "item.occultism.ritual_dummy.possess_phantom"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_PHANTOM.get()), 30, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_PHANTOM_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.flying_passive").entityToSacrifice(OccultismTags.Entities.FLYING_PASSIVE).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_phantom"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_WITCH.get(), "item.occultism.ritual_dummy.possess_witch"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_WITCH.get()), 30, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE}), Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_MUSHROOM})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_WITCH_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").entityToSacrifice(OccultismTags.Entities.CHICKEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_witch"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_POSSESSED_SKELETON.get(), "item.occultism.ritual_dummy.possess_skeleton"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_SKELETON.get()), 15, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((TagKey)Tags.Items.BONES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.POSSESSED_SKELETON_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").entityToSacrifice(OccultismTags.Entities.CHICKEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_skeleton"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.CRUELTY_ESSENCE.get(), "item.occultism.ritual_dummy.possess_goat"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_GOAT.get()), 240, RITUAL_SUMMON, PENTACLE_POSSESS_MARID, Ingredient.of((ItemLike[])new ItemLike[]{Items.POINTED_DRIPSTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POINTED_DRIPSTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_FOOT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_FOOT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_FOOT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_FOOT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ARMADILLO_SCUTE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ARMADILLO_SCUTE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ARMADILLO_SCUTE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ARMADILLO_SCUTE}), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL)).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSummon((EntityType)OccultismEntities.GOAT_OF_MERCY_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_goat"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_IESNIUM_GOLEM.get(), "item.occultism.ritual_dummy.possess_iesnium_golem"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_POSSESS_IESNIUM_GOLEM.get()), 240, RITUAL_SUMMON, PENTACLE_POSSESS_MARID, Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.MARID_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.asItem()}), Ingredient.of((TagKey)Tags.Items.NETHER_STARS), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SOUL_GEM_ITEM})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSummon((EntityType)OccultismEntities.IESNIUM_GOLEM_TYPE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.iron_golem").entityToSacrifice(OccultismTags.Entities.IRON_GOLEM).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_iesnium_golem"));
    }

    private static void familiarRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_GUARDIAN_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_guardian"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_GUARDIAN.get()), 135, RITUAL_FAMILIAR, PENTACLE_POSSESS_AFRIT, Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon((EntityType)OccultismEntities.GUARDIAN_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HUMANS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_guardian"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BAT_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_bat"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_BAT.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.BAT_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.BATS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.bats").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_bat"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BEHOLDER_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_beholder"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_BEHOLDER.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPIDER_EYE}), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.BEHOLDER_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.SPIDERS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.spiders").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_beholder"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_CTHULHU_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_cthulhu"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_CTHULHU.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSacrifice(OccultismTags.Entities.SQUID).entityToSacrificeDisplayName("ritual.occultism.sacrifice.squid").entityToSummon((EntityType)OccultismEntities.CTHULHU_FAMILIAR_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_cthulhu"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_CHIMERA_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_chimera"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_CHIMERA.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.MUTTON}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEF}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHICKEN})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.CHIMERA_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.SHEEP).entityToSacrificeDisplayName("ritual.occultism.sacrifice.sheep").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_chimera"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DEVIL_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_devil"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_DEVIL.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of(OccultismTags.Items.MAGMA), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of(OccultismTags.Items.MAGMA), Ingredient.of((TagKey)Tags.Items.BONES), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.DEVIL_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HORSES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.horses").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_devil"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DRAGON_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_dragon"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_DRAGON.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET}), Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), Ingredient.of((TagKey)ItemTags.COALS), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.OBSIDIAN})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.DRAGON_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HORSES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.horses").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_dragon"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_FAIRY_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_fairy"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_FAIRY.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((TagKey)Tags.Items.BUCKETS_MILK)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.FAIRY_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.HORSES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.horses").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_fairy"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_HEADLESS_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_headless"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_HEADLESS.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT), Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.HAY_BLOCK}), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CARVED_PUMPKIN})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.HEADLESS_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.SNOW_GOLEM).entityToSacrificeDisplayName("ritual.occultism.sacrifice.snow_golem").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_headless"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_MUMMY_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_mummy"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_MUMMY.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.SLIME_BALLS), Ingredient.of((TagKey)Tags.Items.SLIME_BALLS), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.MUMMY_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.LLAMAS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.llamas").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_mummy"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_OTHERWORLD_BIRD.get(), "item.occultism.ritual_dummy.familiar_otherworld_bird"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_OTHERWORLD_BIRD.get()), 90, RITUAL_FAMILIAR, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((TagKey)ItemTags.LEAVES), Ingredient.of((TagKey)Tags.Items.STRINGS)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).entityToSummon((EntityType)OccultismEntities.OTHERWORLD_BIRD_TYPE.get()).entityToSacrifice(OccultismTags.Entities.PARROTS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.parrots").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_otherworld_bird"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BEAVER_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_beaver"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_FAMILIAR_BEAVER), 45, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((TagKey)ItemTags.LOGS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).entityToSummon((EntityType)OccultismEntities.BEAVER_FAMILIAR_TYPE.get()).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_beaver"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_BLACKSMITH_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_blacksmith"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_BLACKSMITH.get()), 45, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_SHOVEL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_PICKAXE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_AXE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ANVIL}), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)Tags.Items.STONES)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.BLACKSMITH_FAMILIAR_TYPE.get()).entityToSacrifice(EntityTypeTags.ZOMBIES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.zombies").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_blacksmith"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_DEER_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_deer"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_DEER.get()), 45, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.STRINGS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.DEER_FAMILIAR_TYPE.get()).entityToSacrifice(OccultismTags.Entities.COWS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.cows").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_deer"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_GREEDY_FAMILIAR.get(), "item.occultism.ritual_dummy.familiar_greedy"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_GREEDY.get()), 45, RITUAL_FAMILIAR, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.CHESTS), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Items.DISPENSER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HOPPER})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon((EntityType)OccultismEntities.GREEDY_FAMILIAR_TYPE.get()).entityToSacrifice(EntityTypeTags.ZOMBIES).entityToSacrificeDisplayName("ritual.occultism.sacrifice.zombies").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_greedy"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg(Items.PARROT_SPAWN_EGG, "item.occultism.ritual_dummy.familiar_parrot"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FAMILIAR_PARROT.get()), 45, OccultismRituals.SUMMON_WITH_CHANCE_OF_CHICKEN_TAMED.getId(), PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.DYES_GREEN), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW), Ingredient.of((TagKey)Tags.Items.DYES_RED), Ingredient.of((TagKey)Tags.Items.DYES_BLUE), Ingredient.of((TagKey)Tags.Items.STRINGS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon(EntityType.PARROT).entityToSacrifice(OccultismTags.Entities.CHICKEN).entityToSacrificeDisplayName("ritual.occultism.sacrifice.chicken").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/familiar_parrot"));
    }

    private static void craftingRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismItems.RITUAL_SATCHEL_T2.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_RITUAL_SATCHEL_T2.get()), 300, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.HOPPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DISPENSER}), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_ritual_satchel_t2"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismBlocks.IESNIUM_SACRIFICIAL_BOWL.asItem()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_IESNIUM_SACRIFICIAL_BOWL.get()), 300, RITUAL_CRAFT, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.RESEARCH_FRAGMENT_DUST}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.asItem()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_iesnium_sacrificial_bowl"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismBlocks.DARK_IESNIUM_SACRIFICIAL_BOWL.asItem()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_DARK_IESNIUM_SACRIFICIAL_BOWL.get()), 300, RITUAL_CRAFT, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.DARK_GOLDEN_SACRIFICIAL_BOWL.asItem()}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.RESEARCH_FRAGMENT_DUST}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.asItem()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_dark_iesnium_sacrificial_bowl"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismItems.WITHERITE_DUST.get(), 3), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_WITHERITE_DUST.get()), 300, RITUAL_CRAFT, PENTACLE_CRAFT_AFRIT, Ingredient.of(OccultismTags.Items.NETHERITE_DUST), Ingredient.of((ItemLike[])new ItemLike[]{Items.WITHER_SKELETON_SKULL}), Ingredient.of(OccultismTags.Items.BLACKSTONE_DUST), Ingredient.of((ItemLike[])new ItemLike[]{Items.WITHER_ROSE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_witherite_dust"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_DIMENSIONAL_MATRIX.get()), 150, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ_BLOCK}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_dimensional_matrix"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_DIMENSIONAL_MINESHAFT.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get(), (ItemLike)OccultismBlocks.OTHERROCK.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get(), (ItemLike)OccultismBlocks.OTHERROCK.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get(), (ItemLike)OccultismBlocks.OTHERROCK.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get(), (ItemLike)OccultismBlocks.OTHERROCK.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_dimensional_mineshaft"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.FAMILIAR_RING.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_FAMILIAR_RING.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_GEM_ITEM.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of(OccultismTags.Items.SILVER_INGOT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_familiar_ring"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.INFUSED_PICKAXE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_INFUSED_PICKAXE.get()), 150, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_DJINNI, Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((TagKey)Tags.Items.RODS_WOODEN), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_PICKAXE_HEAD.get()}), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of(OccultismTags.Items.SILVER_INGOT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_infused_pickaxe"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.SOUL_GEM_ITEM.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_SOUL_GEM.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.FRAGILE_SOUL_GEM_ITEM}), Ingredient.of((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS), Ingredient.of((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS), Ingredient.of((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_soul_gem"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.STORAGE_REMOTE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STORAGE_REMOTE.get()), 150, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.STORAGE_REMOTE_INERT.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_storage_remote"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.GRAY_PASTE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_GRAY_PASTE.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((TagKey)Tags.Items.GUNPOWDERS), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY_BALL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.PHANTOM_MEMBRANE}), Ingredient.of((TagKey)Tags.Items.DYES_GRAY)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_gray_paste"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismBlocks.ENTITY_WORMHOLE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_ENTITY_WORMHOLE.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERSTONE_FRAME.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.OBSIDIANS_CRYING), Ingredient.of(OccultismTags.Items.IESNIUM_INGOT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_entity_wormhole"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismBlocks.ENTITY_WORMHOLE_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_ENTITY_WORMHOLE_DARK.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERROCK_FRAME.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.OBSIDIANS_CRYING), Ingredient.of(OccultismTags.Items.IESNIUM_INGOT)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_entity_wormhole_dark"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.ENDER_SATCHEL.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_ENDER_SATCHEL.get()), 150, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_DJINNI, Ingredient.of((TagKey)Tags.Items.CHESTS_ENDER), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_ender_satchel"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.RITUAL_SATCHEL_T1.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_RITUAL_SATCHEL_T1.get()), 60, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.HOPPER}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DISPENSER}), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of(OccultismTags.Items.SILVER_INGOT)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_ritual_satchel_t1"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.KNOWLEDGE_TABLET.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_KNOWLEDGE_TABLET.get()), 60, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLDLY_TABLET}), Ingredient.of(OccultismTags.Items.RESEARCH_DUST), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_knowledge_tablet"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.INFUSED_LENSES.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_INFUSED_LENSES.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.LENSES.get()}), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of(OccultismTags.Items.SILVER_INGOT), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_infused_lenses"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.SATCHEL.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_SATCHEL.get()), 60, RITUAL_CRAFT_WITH_SPIRIT_NAME, PENTACLE_CRAFT_FOLIOT, Ingredient.of((TagKey)Tags.Items.CHESTS_WOODEN), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of(OccultismTags.Items.SILVER_INGOT)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_satchel"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STABLE_WORMHOLE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABLE_WORMHOLE.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERSTONE_FRAME.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stable_wormhole"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STABLE_WORMHOLE_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABLE_WORMHOLE_DARK.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERROCK_FRAME.get()}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), Ingredient.of((TagKey)Tags.Items.GEMS_QUARTZ), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stable_wormhole_dark"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STORAGE_CONTROLLER_BASE.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_storage_controller_base"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STORAGE_CONTROLLER_BASE_DARK.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERROCK_PEDESTAL.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_storage_controller_base_dark"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.RESEARCH_FRAGMENT_DUST.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_RESEARCH_FRAGMENT_DUST.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of(OccultismTags.Items.EMERALD_DUST), Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_research_fragment_dust"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.NATURE_PASTE.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_NATURE_PASTE.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((TagKey)ItemTags.LEAVES), Ingredient.of((TagKey)ItemTags.SAPLINGS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)ItemTags.LEAVES), Ingredient.of((TagKey)ItemTags.SAPLINGS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)ItemTags.LEAVES), Ingredient.of((TagKey)ItemTags.SAPLINGS), Ingredient.of((TagKey)Tags.Items.SEEDS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_nature_paste"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.VITALITY_COMPASS.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_VITALITY_COMPASS.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((TagKey)Tags.Items.GEMS_AMETHYST), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COMPASS}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_vitality_compass"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.FRAGILE_SOUL_GEM_ITEM.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_FRAGILE_SOUL_GEM.get()), 30, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_fragile_soul_gem"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismItems.DRAGONYST_DUST.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_DRAGONYST_DUST.get()), 510, RITUAL_CRAFT, PENTACLE_CRAFT_MARID, Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.END_STONE_DUST), Ingredient.of((ItemLike[])new ItemLike[]{Items.END_CRYSTAL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.END_CRYSTAL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.END_CRYSTAL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.END_CRYSTAL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_dragonyst_dust"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismBlocks.IESNIUM_ANVIL.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_IESNIUM_ANVIL.get()), 510, RITUAL_CRAFT, PENTACLE_CRAFT_MARID, Ingredient.of((ItemLike[])new ItemLike[]{Items.ANVIL}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MARID_ESSENCE.get()})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_iesnium_anvil"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismItems.TRUE_SIGHT_STAFF.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_TRUE_SIGHT_STAFF.get()), 510, RITUAL_CRAFT, PENTACLE_CRAFT_MARID, Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.IESNIUM_PICKAXE}), Ingredient.of(OccultismTags.Items.OTHERWORLD_GOGGLES), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.DIVINATION_ROD}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.MARID_ESSENCE})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_true_sight_staff"));
    }

    private static void stabilizerRecipes(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER1.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER0.get()}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of(OccultismTags.Items.BLAZE_DUST), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier1"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER1_DARK.get()), 60, RITUAL_CRAFT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER0_DARK.get()}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of(OccultismTags.Items.BLAZE_DUST), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier1_dark"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER2.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1.get()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_SILVER), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier2"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER2_DARK.get()), 150, RITUAL_CRAFT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER1_DARK.get()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_SILVER), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier2_dark"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER3.get()), 300, RITUAL_CRAFT, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2.get()}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{Items.TOTEM_OF_UNDYING}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier3"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER3_DARK.get()), 300, RITUAL_CRAFT, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER2_DARK.get()}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{Items.TOTEM_OF_UNDYING}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier3_dark"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER4.get()), 510, RITUAL_CRAFT, PENTACLE_CRAFT_MARID, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3.get()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{Items.BEACON}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MARID_ESSENCE.get()})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier4"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER4_DARK.get()), 510, RITUAL_CRAFT, PENTACLE_CRAFT_MARID, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER3_DARK.get()}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{Items.BEACON}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MARID_ESSENCE.get()})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_stabilizer_tier4_dark"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER5.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER5.get()), 780, RITUAL_CRAFT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SHRIEKER}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_NETHERITE), Ingredient.of((TagKey)Tags.Items.OBSIDIANS_CRYING), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENCHANTED_GOLDEN_APPLE}), Ingredient.of(OccultismTags.Items.DRAGONYST_DUST)).entityToSacrificeDisplayName("ritual.occultism.sacrifice.endermen").entityToSacrifice(OccultismTags.Entities.ENDERMEN).unlockedBy("has_stabilizer_tier4", RitualRecipes.has((ItemLike)((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_stabilizer_tier5"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4_DARK.get()}), new ItemStack((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_STABILIZER_TIER5_DARK.get()), 780, RITUAL_CRAFT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_SHRIEKER}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_NETHERITE), Ingredient.of((TagKey)Tags.Items.OBSIDIANS_CRYING), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ENCHANTED_GOLDEN_APPLE}), Ingredient.of(OccultismTags.Items.DRAGONYST_DUST)).entityToSacrificeDisplayName("ritual.occultism.sacrifice.endermen").entityToSacrifice(OccultismTags.Entities.ENDERMEN).unlockedBy("has_stabilizer_tier4", RitualRecipes.has((ItemLike)((ItemLike)OccultismBlocks.STORAGE_STABILIZER_TIER4_DARK.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_stabilizer_tier5_dark"));
    }

    private static void minerRecipes(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), new ItemStack((ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_MINER_FOLIOT_UNSPECIALIZED.get()), 60, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((TagKey)Tags.Items.GRAVELS)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_foliot_unspecialized"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), new ItemStack((ItemLike)OccultismItems.MINER_DJINNI_ORES.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_MINER_DJINNI_ORES.get()), 150, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_FOLIOT_UNSPECIALIZED.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_LAPIS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_djinni_ores"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_MINER_AFRIT_DEEPS.get()), 300, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_DJINNI_ORES.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.AFRIT_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CRYING_OBSIDIAN})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_afrit_deeps"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()}), new ItemStack((ItemLike)OccultismItems.MINER_MARID_MASTER.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_CRAFT_MINER_MARID_MASTER.get()), 510, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CRAFT_MARID, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_AFRIT_DEEPS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.IESNIUM_PICKAXE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_PICKAXE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRAGON_BREATH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TOTEM_OF_UNDYING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_STAR}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MARID_ESSENCE.get()})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_miner_marid_master"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINING_DIMENSION_CORE_PIECE.get()}), new ItemStack((ItemLike)OccultismItems.MINER_ANCIENT_ELDRITCH.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_MINER_ANCIENT_ELDRITCH.get()), 780, RITUAL_CRAFT_MINER_SPIRIT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.MINER_MARID_MASTER.get()})).unlockedBy("has_mining_dimension_core", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.MINING_DIMENSION_CORE_PIECE.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_miner_ancient_eldritch"));
    }

    private static void resurrectRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.SOUL_SHARD_ITEM.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.RESURRECT_ICON.get(), "item.occultism.ritual_dummy.resurrect_familiar"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_RESURRECT_FAMILIAR.get()), 15, OccultismRituals.RESURRECT_FAMILIAR.getId(), PENTACLE_RESURRECT_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()})).unlockedBy("has_otherworld_essence", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/resurrect_familiar"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), RitualRecipes.makeLoreSpawnEgg(Items.ALLAY_SPAWN_EGG, "item.occultism.ritual_dummy.resurrect_allay"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_RESURRECT_ALLAY.get()), 30, RITUAL_SUMMON, PENTACLE_RESURRECT_SPIRIT, Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), Ingredient.of((TagKey)Tags.Items.DUSTS_GLOWSTONE), Ingredient.of(OccultismTags.Items.SILVER_DUST), Ingredient.of(OccultismTags.Items.GOLD_DUST)).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).entityToSummon(EntityType.ALLAY).entityToSacrificeDisplayName("ritual.occultism.sacrifice.vex").entityToSacrifice(OccultismTags.Entities.VEX).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/resurrect_allay"));
    }

    private static void repairRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of(OccultismTags.Items.TOOLS_CHALK), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.REPAIR_ICON.get(), "item.occultism.ritual_dummy.repair_chalks"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_REPAIR_CHALKS.get()), 5, RITUAL_REPAIR, PENTACLE_CRAFT_DJINNI, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM})).unlockedBy("has_white_chalk", RitualRecipes.has(OccultismItems.CHALK_WHITE)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/repair_chalks"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((TagKey)Tags.Items.TOOLS), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.REPAIR_ICON.get(), "item.occultism.ritual_dummy.repair_tools"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_REPAIR_TOOLS.get()), 30, RITUAL_REPAIR, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM})).unlockedBy("has_bound_afrit", RitualRecipes.has(OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/repair_tools"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((TagKey)Tags.Items.ARMORS), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.REPAIR_ICON.get(), "item.occultism.ritual_dummy.repair_armors"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_REPAIR_ARMORS.get()), 30, RITUAL_REPAIR, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM})).unlockedBy("has_bound_afrit", RitualRecipes.has(OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/repair_armors"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of(OccultismTags.Items.Miners.MINERS), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.REPAIR_ICON.get(), "item.occultism.ritual_dummy.repair_miners"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_REPAIR_MINERS.get()), 30, RITUAL_REPAIR, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.OTHERWORLD_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM})).unlockedBy("has_bound_afrit", RitualRecipes.has(OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/repair_miners"));
    }

    private static void contactRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.SKELETON_SKULL}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_HUNT_WITHER_SKELETON.get(), "item.occultism.ritual_dummy.wild_hunt"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_HUNT.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_SILVER), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.NETHERRACKS), Ingredient.of((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.WILD_HUNT_WITHER_SKELETON.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_hunt"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((TagKey)ItemTags.PICKAXES), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_HORDE_HUSK.get(), "item.occultism.ritual_dummy.wild_husk"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_HUSK.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.SANDSTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DEAD_BUSH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.WILD_HORDE_HUSK.get()).summonNumber(5).entityToSacrificeDisplayName("ritual.occultism.sacrifice.camel").entityToSacrifice(OccultismTags.Entities.CAMEL).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_husk"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.FISHING_ROD}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_HORDE_DROWNED.get(), "item.occultism.ritual_dummy.wild_drowned"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_DROWNED.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.PUFFERFISH}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.WILD_HORDE_DROWNED.get()).summonNumber(5).entityToSacrificeDisplayName("ritual.occultism.sacrifice.fish").entityToSacrifice(OccultismTags.Entities.FISH).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_drowned"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT_AND_STEEL}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_HORDE_CREEPER.get(), "item.occultism.ritual_dummy.wild_creeper"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_CREEPER.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TNT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}), Ingredient.of((TagKey)ItemTags.LEAVES)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.WILD_HORDE_CREEPER.get()).summonNumber(5).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_creeper"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.BRUSH}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_HORDE_SILVERFISH.get(), "item.occultism.ritual_dummy.wild_silverfish"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_SILVERFISH.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.SAND}), Ingredient.of((TagKey)ItemTags.TERRACOTTA), Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL}), Ingredient.of((TagKey)ItemTags.TERRACOTTA)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.WILD_HORDE_SILVERFISH.get()).summonNumber(5).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_silverfish"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_WEAK_BREEZE.get(), "item.occultism.ritual_dummy.wild_weak_breeze"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_WEAK_BREEZE.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_COPPER), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.POSSESSED_WEAK_BREEZE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_weak_breeze"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.TRIAL_KEY}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_BREEZE.get(), "item.occultism.ritual_dummy.wild_breeze"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_BREEZE.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.POSSESSED_BREEZE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_breeze"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.OMINOUS_TRIAL_KEY}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_STRONG_BREEZE.get(), "item.occultism.ritual_dummy.wild_strong_breeze"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_STRONG_BREEZE.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_BULB}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TUFF_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BREEZE_ROD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BREEZE_ROD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.OMINOUS_BOTTLE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.POSSESSED_STRONG_BREEZE.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_strong_breeze"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.SPAWN_EGG_WILD_EVOKER.get(), "item.occultism.ritual_dummy.wild_horde_illager"), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_WILD_ILLAGER.get()), 90, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_OAK_LOG}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DARK_OAK_LOG}), Ingredient.of(OccultismTags.Items.EMERALD_DUST), Ingredient.of(OccultismTags.Items.EMERALD_DUST), Ingredient.of(OccultismTags.Items.EMERALD_DUST)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSummon(OccultismEntities.POSSESSED_EVOKER.get()).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_horde_illager"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND_BLOCK}), new ItemStack((ItemLike)Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_WILD_TRIM.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSSY_COBBLESTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.JUNGLE_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLISTERING_MELON_SLICE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSSY_COBBLESTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.JUNGLE_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLISTERING_MELON_SLICE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSSY_COBBLESTONE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.JUNGLE_SAPLING}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLISTERING_MELON_SLICE})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrifice(OccultismTags.Entities.LLAMAS).entityToSacrificeDisplayName("ritual.occultism.sacrifice.llamas").save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_wild_trim"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK}), new ItemStack((ItemLike)Items.BUDDING_AMETHYST), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_BUDDING_AMETHYST.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.AMETHYST_DUST), Ingredient.of(OccultismTags.Items.AMETHYST_DUST)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.pigs").entityToSacrifice(OccultismTags.Entities.PIGS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_budding_amethyst"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE}), new ItemStack((ItemLike)Items.REINFORCED_DEEPSLATE), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_REINFORCED_DEEPSLATE.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BARS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BARS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BARS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BARS}), Ingredient.of((TagKey)Tags.Items.OBSIDIANS), Ingredient.of((TagKey)Tags.Items.OBSIDIANS), Ingredient.of((TagKey)Tags.Items.OBSIDIANS), Ingredient.of((TagKey)Tags.Items.OBSIDIANS), Ingredient.of(OccultismTags.Items.IESNIUM_INGOT)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.warden").entityToSacrifice(OccultismTags.Entities.WARDEN).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_reinforced_deepslate"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEHIVE}), new ItemStack((ItemLike)Items.BEE_NEST), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_BEE_NEST.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB_BLOCK}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB_BLOCK})).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.bees").entityToSacrifice(OccultismTags.Entities.BEES).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_bee_nest"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_GOLD), new ItemStack((ItemLike)Items.BELL), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_BELL.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.NUGGETS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHAIN}), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)Tags.Items.STONES), Ingredient.of((TagKey)ItemTags.LOGS)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.goats").entityToSacrifice(OccultismTags.Entities.GOATS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_bell"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_HORSE_ARMOR}), new ItemStack((ItemLike)Items.IRON_HORSE_ARMOR), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_IRON_HORSE_ARMOR.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.armadillos").entityToSacrifice(OccultismTags.Entities.ARMADILLOS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_iron_horse_armor"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_HORSE_ARMOR}), new ItemStack((ItemLike)Items.GOLDEN_HORSE_ARMOR), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_GOLDEN_HORSE_ARMOR.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.armadillos").entityToSacrifice(OccultismTags.Entities.ARMADILLOS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_golden_horse_armor"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER_HORSE_ARMOR}), new ItemStack((ItemLike)Items.DIAMOND_HORSE_ARMOR), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_DIAMOND_HORSE_ARMOR.get()), 180, RITUAL_CRAFT, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.armadillos").entityToSacrifice(OccultismTags.Entities.ARMADILLOS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_diamond_horse_armor"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.DARK_IESNIUM_SACRIFICIAL_BOWL.asItem()}), new ItemStack((ItemLike)OccultismBlocks.ELDRITCH_CHALICE.asItem()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_ELDRITCH_CHALICE.get()), 780, RITUAL_CRAFT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.HEAVY_CORE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BELL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_LANTERN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FLOWER}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_NETHERITE), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPONGE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REINFORCED_DEEPSLATE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RESPAWN_ANCHOR}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{Items.END_STONE_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_CATALYST}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BUDDING_AMETHYST})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.ravager").entityToSacrifice(OccultismTags.Entities.RAVAGER).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_eldritch_chalice"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.IESNIUM_SACRIFICIAL_BOWL.asItem()}), new ItemStack((ItemLike)OccultismBlocks.CELESTIAL_CHALICE.asItem()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_CELESTIAL_CHALICE.get()), 780, RITUAL_CRAFT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.HEAVY_CORE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BELL}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_LANTERN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FLOWER}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_NETHERITE), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPONGE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.REINFORCED_DEEPSLATE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.RESPAWN_ANCHOR}), Ingredient.of(OccultismTags.Items.STORAGE_BLOCK_IESNIUM), Ingredient.of((ItemLike[])new ItemLike[]{Items.END_STONE_BRICKS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SCULK_CATALYST}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BUDDING_AMETHYST})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.ravager").entityToSacrifice(OccultismTags.Entities.RAVAGER).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_celestial_chalice"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.BRUSH}), new ItemStack((ItemLike)OccultismItems.CHALK_RAINBOW.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_CHALK_RAINBOW.get()), 780, RITUAL_CRAFT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_RED}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_BROWN}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_ORANGE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_YELLOW}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_LIME}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_GREEN}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_CYAN}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_BLUE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_LIGHT_BLUE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_PINK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_MAGENTA}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_PURPLE})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.sheep").entityToSacrifice(OccultismTags.Entities.SHEEP).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_chalk_rainbow"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.BRUSH}), new ItemStack((ItemLike)OccultismItems.CHALK_VOID.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_CHALK_VOID.get()), 780, RITUAL_CRAFT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_WHITE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_LIGHT_GRAY}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_GRAY}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CHALK_BLACK})).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_chalk_void"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SOUL_GEM_ITEM}), new ItemStack((ItemLike)OccultismItems.TRINITY_GEM_ITEM.get()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_TRINITY_GEM.get()), 780, RITUAL_CRAFT, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.AFRIT_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.MARID_ESSENCE}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.CRUELTY_ESSENCE}), Ingredient.of(OccultismTags.Items.ECHO_DUST), Ingredient.of(OccultismTags.Items.DRAGONYST_DUST), Ingredient.of(OccultismTags.Items.WITHERITE_DUST), Ingredient.of(OccultismTags.Items.IESNIUM_DUST), Ingredient.of(OccultismTags.Items.IESNIUM_DUST), Ingredient.of(OccultismTags.Items.IESNIUM_DUST)).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.humans").entityToSacrifice(OccultismTags.Entities.HUMANS).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_trinity_gem"));
    }

    private static void randomRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.possess_random_animal_common"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_POSSESS_RANDOM_ANIMAL_COMMON), 15, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.CROPS), Ingredient.of((TagKey)Tags.Items.CROPS), Ingredient.of((TagKey)Tags.Items.CROPS), Ingredient.of((TagKey)Tags.Items.CROPS)).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_COMMON).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_random_animal_common"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.possess_random_animal_water"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_POSSESS_RANDOM_ANIMAL_WATER), 15, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MUD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MUD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_WATER).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.SNOWBALL})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_random_animal_water"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.possess_random_animal_small"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_POSSESS_RANDOM_ANIMAL_SMALL), 15, RITUAL_SUMMON, PENTACLE_POSSESS_FOLIOT, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.NUGGETS_IRON), Ingredient.of((TagKey)Tags.Items.NUGGETS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_SMALL).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).unlockedBy("has_bound_foliot", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_random_animal_small"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.possess_random_animal_rideable"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_POSSESS_RANDOM_ANIMAL_RIDEABLE), 30, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_WHEAT), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_WHEAT), Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), Ingredient.of((TagKey)Tags.Items.CROPS_CACTUS), Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_RIDEABLE).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_random_animal_rideable"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.possess_villager"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_POSSESS_VILLAGER), 30, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)ItemTags.BEDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.CAMPFIRE}), Ingredient.of((TagKey)Tags.Items.FOODS_PIE)).entityTagToSummon(OccultismTags.Entities.VILLAGERS).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_villager"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.possess_random_animal_special"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_POSSESS_RANDOM_ANIMAL_SPECIAL), 30, RITUAL_SUMMON, PENTACLE_POSSESS_DJINNI, Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of(OccultismTags.Items.MUSHROOM_BLOCKS), Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Items.PACKED_ICE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TERRACOTTA}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_BLOCK})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_SPECIAL).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.WIND_CHARGE})).unlockedBy("has_bound_djinni", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/possess_random_animal_special"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.wild_random_animal_common"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_WILD_RANDOM_ANIMAL_COMMON), 45, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.SEEDS), Ingredient.of((TagKey)Tags.Items.CROPS), Ingredient.of((TagKey)Tags.Items.CROPS), Ingredient.of((TagKey)Tags.Items.CROPS), Ingredient.of((TagKey)Tags.Items.CROPS)).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_COMMON).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).unlockedBy("has_spirit_attuned_gem", RitualRecipes.has(OccultismItems.SPIRIT_ATTUNED_GEM)).summonNumber(7).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_random_animal_common"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.wild_random_animal_water"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_WILD_RANDOM_ANIMAL_WATER), 45, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SEAGRASS}), Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MUD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.MUD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CLAY})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_WATER).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.SNOWBALL})).unlockedBy("has_spirit_attuned_gem", RitualRecipes.has(OccultismItems.SPIRIT_ATTUNED_GEM)).summonNumber(7).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_random_animal_water"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.wild_random_animal_small"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_WILD_RANDOM_ANIMAL_SMALL), 45, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.FEATHERS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.STRINGS), Ingredient.of((TagKey)Tags.Items.NUGGETS_IRON), Ingredient.of((TagKey)Tags.Items.NUGGETS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_SMALL).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EGG})).unlockedBy("has_spirit_attuned_gem", RitualRecipes.has(OccultismItems.SPIRIT_ATTUNED_GEM)).summonNumber(7).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_random_animal_small"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.wild_random_animal_rideable"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_WILD_RANDOM_ANIMAL_RIDEABLE), 45, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_WHEAT), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_WHEAT), Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), Ingredient.of((TagKey)Tags.Items.CROPS_CACTUS), Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_RIDEABLE).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE})).unlockedBy("has_spirit_attuned_gem", RitualRecipes.has(OccultismItems.SPIRIT_ATTUNED_GEM)).summonNumber(3).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_random_animal_rideable"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.wild_villager"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_WILD_VILLAGER), 45, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)ItemTags.BEDS), Ingredient.of((ItemLike[])new ItemLike[]{Items.CAMPFIRE}), Ingredient.of((TagKey)Tags.Items.FOODS_PIE)).entityTagToSummon(OccultismTags.Entities.VILLAGERS).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.EXPERIENCE_BOTTLE})).unlockedBy("has_spirit_attuned_gem", RitualRecipes.has(OccultismItems.SPIRIT_ATTUNED_GEM)).summonNumber(3).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_villager"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.SPIRIT_ATTUNED_GEM}), RitualRecipes.makeLoreSpawnEgg((Item)OccultismItems.MYSTERIOUS_EGG_ICON.get(), "item.occultism.ritual_dummy.wild_random_animal_special"), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_WILD_RANDOM_ANIMAL_SPECIAL), 45, RITUAL_SUMMON_WILD, PENTACLE_CONTACT_WILD_SPIRIT, Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of((TagKey)ItemTags.WOOL), Ingredient.of(OccultismTags.Items.MUSHROOM_BLOCKS), Ingredient.of((ItemLike[])new ItemLike[]{Items.MOSS_BLOCK}), Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Items.PACKED_ICE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.TERRACOTTA}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO_BLOCK})).entityTagToSummon(OccultismTags.Entities.RANDOM_ANIMALS_SPECIAL).itemToUse(Ingredient.of((ItemLike[])new ItemLike[]{Items.WIND_CHARGE})).unlockedBy("has_spirit_attuned_gem", RitualRecipes.has(OccultismItems.SPIRIT_ATTUNED_GEM)).summonNumber(3).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/wild_random_animal_special"));
    }

    private static void upgradeRituals(RecipeOutput recipeOutput) {
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()}), new ItemStack((ItemLike)OccultismItems.RITUAL_SATCHEL_T2.get()), RitualRecipes.makeRitualDummy(OccultismItems.RITUAL_DUMMY_CRAFT_UPGRADE_RITUAL_SATCHEL), 180, RITUAL_UPGRADE, PENTACLE_CRAFT_AFRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.RITUAL_SATCHEL_T1}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.AFRIT_ESSENCE}), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).unlockedBy("has_bound_afrit", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/craft_upgrade_ritual_satchel"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of(OccultismTags.Items.ECHO_DUST), new ItemStack((ItemLike)OccultismBlocks.STORAGE_CONTROLLER_STABILIZED.asItem()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_STABILIZED_STORAGE.get()), 780, RITUAL_UPGRADE, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_CONTROLLER}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of(OccultismTags.Items.ECHO_DUST), Ingredient.of(OccultismTags.Items.ECHO_DUST)).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.shulker").entityToSacrifice(OccultismTags.Entities.SHULKER).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_stabilized_storage"));
        RitualRecipeBuilder.ritualRecipeBuilder(Ingredient.of(OccultismTags.Items.ECHO_DUST), new ItemStack((ItemLike)OccultismBlocks.STORAGE_CONTROLLER_STABILIZED_DARK.asItem()), RitualRecipes.makeRitualDummy((ItemLike)OccultismItems.RITUAL_DUMMY_FORGE_STABILIZED_STORAGE_DARK.get()), 780, RITUAL_UPGRADE, PENTACLE_CONTACT_ELDRITCH_SPIRIT, Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_CONTROLLER_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of((ItemLike[])new ItemLike[]{OccultismBlocks.STORAGE_STABILIZER_TIER5, OccultismBlocks.STORAGE_STABILIZER_TIER5_DARK}), Ingredient.of(OccultismTags.Items.ECHO_DUST), Ingredient.of(OccultismTags.Items.ECHO_DUST)).unlockedBy("has_bound_marid", RitualRecipes.has((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get()))).entityToSacrificeDisplayName("ritual.occultism.sacrifice.shulker").entityToSacrifice(OccultismTags.Entities.SHULKER).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"ritual/misc_stabilized_storage_dark"));
    }
}

