/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.summoning_rituals;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TransporterEntry
extends EntryProvider {
    public static final String ENTRY_ID = "summon_transport_items";

    public TransporterEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)Items.CHEST_MINECART);
    }

    protected String entryName() {
        return "Summon Foliot Transporter";
    }

    protected String entryDescription() {
        return "Moving around";
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Foliot Transporter");
        this.pageText("The transporter is useful in that you don't need a train of hoppers\ntransporting stuff, and can use any inventory to take from and deposit.\n\\\n\\\nTo make it take from an inventory simply sneak and interact\nwith it's book of calling on the inventory you want.\n");
        this.page("intro2", () -> BookTextPageModel.create().withText(this.context().pageText()));
        this.pageText("You can also dictate which inventory it deposits to in the same way.\n\\\nThe transporter will move all items it can access from one inventory to another,\n including machines. It can also deposit into the inventories of other spirits.\n By setting the extract and insert side they can be used to automate various transport tasks.\n");
        this.page("spirit_inventories", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Spirit Inventories");
        this.pageText("The Transporter can also interact with the inventories of other spirits.\nThis is especially useful to automatically supply a {0} with items to crush,\na {1} with items to smelt or a {2} with items to crystallize.\n", new Object[]{this.entryLink("Crusher spirit", "summoning_rituals", "summon_crusher_t1"), this.entryLink("Smelter spirit", "summoning_rituals", "summon_smelter_t1"), this.entryLink("Crystallizer spirit", "summoning_rituals", "summon_crystallizer_t1")});
        this.page("item_filters", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Item Filters");
        this.pageText("By default the Transporter is in \"Whitelist\" mode and will not move anything.\nShift-click the transporter to open the config UI. You can then add items to\nthe filter list to make it move only those items, or set it to \"Blacklist\"\nto move everything *except* the filtered items. You can also enter a tag in\nthe text field below to filter by tag.\n");
        this.page("ritual", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_transport_items")));
        this.page("book_of_calling", () -> (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/book_of_calling_foliot_transport_items"))).withText(this.context().pageText()));
        this.pageText("If you lose the book of calling, you can craft a new one.\n{0} the spirit with the crafted book to assign it.\n", new Object[]{this.color("Shift-right-click", ChatFormatting.GREEN)});
        this.page("usage", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Usage");
        this.pageText(" Use the book of calling to set the extract and insert location of the transporter.\n \\\n \\\n See {0} for more information.\n", new Object[]{this.entryLink("Books of Calling", "getting_started", "books_of_calling")});
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

