/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.summoning_rituals;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SmelterFoliotEntry
extends EntryProvider {
    public static final String ENTRY_ID = "summon_smelter_t1";

    public SmelterFoliotEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)Items.COPPER_INGOT);
    }

    protected String entryName() {
        return "Summon Foliot Smelter";
    }

    protected String entryDescription() {
        return "BURN";
    }

    protected void generatePages() {
        this.page("about_smelters", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Smelter Spirits");
        this.pageText("Smelter spirits are summoned to do furnace, blast furnace, smoker and campfire process,\nwithout using fuel. They will pick up appropriate items and drop the resulting into the world.\nA fire particle effect and a flame sound indicate the smelter is at work.\n");
        this.page("automation", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Automation");
        this.pageText("To ease automation, try summoning a {0} to place items from chests\n in the smelter''s inventory, and a {1} to collect the processed items.\n", new Object[]{this.entryLink("Transporter Spirit", "summoning_rituals", "summon_transport_items"), this.entryLink("Janitor Spirit", "summoning_rituals", "summon_cleaner")});
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Foliot Smelter");
        this.pageText("The foliot smelter is the most basic smelter spirit.\n\\\n\\\nIt will smelt an item at the same speed as the furnace.\n");
        this.page("ritual", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/summon_foliot_smelter")));
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

