/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.book.binding_rituals;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePageModel;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MinerFoliotEntry
extends EntryProvider {
    public static final String ENTRY_ID = "craft_foliot_miner";

    public MinerFoliotEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create(OccultismItems.MINER_FOLIOT_UNSPECIALIZED);
    }

    protected String entryName() {
        return "Foliot Miner";
    }

    protected String entryDescription() {
        return "Stone, stone and ores";
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Foliot Miner");
        this.pageText("Miner spirits use {0} to acquire resources from other dimensions.\n They are summoned and bound into magic lamps, which they can leave only through the mineshaft.\n The magic lamp degrades over time, once it breaks the spirit is released back to {1}.\n", new Object[]{this.itemLink((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT), this.color("The Other Place", ChatFormatting.DARK_PURPLE)});
        this.page("magic_lamp", () -> (BookCraftingRecipePageModel)((BookCraftingRecipePageModel)BookCraftingRecipePageModel.create().withRecipeId1(this.modLoc("crafting/magic_lamp_empty"))).withText(this.context().pageText()));
        this.pageText("To summon miner spirits, you first need to craft a {0} to hold them.\n The key ingredient for that is {1}.\n", new Object[]{this.entryLink("Magic Lamp", "getting_started", "magic_lamps"), this.itemLink((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM)});
        this.page("spotlight", () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{OccultismItems.MINER_FOLIOT_UNSPECIALIZED})).withText(this.context().pageText()));
        this.pageText("The {0} miner harvests block without much aim and returns anything it finds.\n The mining process is quite slow, due to this the Foliot expends only minor\n amounts of energy, damaging the lamp it is housed in slowly over time.\n", new Object[]{this.color("Foliot", ChatFormatting.DARK_PURPLE)});
        this.page("ritual", () -> (BookRitualRecipePageModel)BookRitualRecipePageModel.create().withRecipeId1(this.modLoc("ritual/craft_miner_foliot_unspecialized")));
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

