/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MagicLampItem
extends Item {
    private static final MapCodec<EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");

    public MagicLampItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        Level level = context.getLevel();
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        if (itemStack.has(DataComponents.ENTITY_DATA)) {
            if (player != null && !level.isClientSide) {
                CompoundTag entityData = Objects.requireNonNull((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).copyTag();
                itemStack.remove(DataComponents.ENTITY_DATA);
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                BlockPos spawnPos = pos.immutable();
                if (!level.getBlockState(spawnPos).getCollisionShape((BlockGetter)level, spawnPos).isEmpty()) {
                    spawnPos = spawnPos.relative(facing);
                }
                entityData.remove("Pos");
                CompoundTag wrapper = new CompoundTag();
                wrapper.put("EntityTag", (Tag)entityData);
                Entity entity = type.create(level);
                assert (entity != null);
                entity.load(entityData);
                entity.absMoveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                float yaw = player.getYHeadRot() + 180.0f;
                entity.setYRot(yaw);
                entity.setYBodyRot(yaw);
                entity.setYHeadRot(yaw);
                entity.setYRot(yaw);
                entity.setYRot(yaw);
                level.addFreshEntity(entity);
                ItemNBTUtil.setSpiritJob(itemStack, "");
                ItemNBTUtil.setBoundSpiritName(itemStack, TextUtil.SPIRIT_NAME_NOT_YET_KNOWN);
                player.swing(context.getHand());
                player.inventoryMenu.broadcastChanges();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        SpiritEntity spirit;
        if (hand != InteractionHand.MAIN_HAND || !target.isAlive() || target.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof SpiritEntity && (spirit = (SpiritEntity)target).getJob().isPresent() && spirit.isOwnedBy((LivingEntity)player))) {
            return InteractionResult.FAIL;
        }
        CompoundTag entityData = new CompoundTag();
        String id = target.getEncodeId();
        if (id != null) {
            entityData.putString("id", id);
        }
        entityData = target.saveWithoutId(entityData);
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
        ItemNBTUtil.setBoundSpiritName(stack, target.getName().getString());
        ItemNBTUtil.setSpiritJob(stack, spirit.getJobID());
        player.swing(hand);
        player.setItemInHand(hand, stack);
        target.remove(Entity.RemovalReason.DISCARDED);
        player.inventoryMenu.broadcastChanges();
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public String getDescriptionId(ItemStack stack) {
        return stack.has(DataComponents.ENTITY_DATA) ? this.getDescriptionId().replace("empty", "filled") : this.getDescriptionId();
    }

    protected EntityType<?> getType(ItemStack pStack) {
        CustomData customdata = (CustomData)pStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        return (EntityType)customdata.read(ENTITY_TYPE_FIELD_CODEC).getOrThrow();
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(DataComponents.ENTITY_DATA)) {
            EntityType<?> type = this.getType(pStack);
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip_filled"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack)), type.getDescription(), Component.translatable((String)("job.occultism." + ItemNBTUtil.getSpiritJob(pStack).split(":", 2)[1]))}));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip_empty")));
        }
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return pStack.has(DataComponents.ENTITY_DATA);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (stack.has(DataComponents.ENTITY_DATA) && level.getGameTime() % 20L == 0L && level.getRandom().nextInt(100) == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".spirit_message_" + level.getRandom().nextInt(10)), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}), false);
            if (player.isSleeping()) {
                player.hurt(player.damageSources().magic(), 1.0f);
            }
        }
    }
}

