/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class FamiliarRingItem
extends Item {
    public FamiliarRingItem(Item.Properties properties) {
        super(properties);
    }

    private static Curio getCurio(ItemStack stack) {
        ICurio icurio = (ICurio)stack.getCapability(CuriosCapability.ITEM);
        if (icurio != null && icurio instanceof Curio) {
            Curio curio = (Curio)icurio;
            return curio;
        }
        return null;
    }

    public static IFamiliar getFamiliar(ItemStack stack, Level level) {
        Curio curio = FamiliarRingItem.getCurio(stack);
        return curio == null ? null : curio.getFamiliar(level);
    }

    public int getMaxStackSize(ItemStack stack) {
        ItemNBTUtil.getBoundSpiritName(stack);
        return super.getMaxStackSize(stack);
    }

    public boolean isFoil(ItemStack pStack) {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            return DistHelper.isFoil(pStack);
        }
        return false;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(OccultismDataComponents.OCCUPIED) && FMLLoader.getDist() == Dist.CLIENT) {
            DistHelper.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)(pStack.getDescriptionId() + ".tooltip.empty")));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        IFamiliar familiar;
        if (!playerIn.level().isClientSide && target instanceof IFamiliar && ((familiar = (IFamiliar)target).getFamiliarOwner() == playerIn || familiar.getFamiliarOwner() == null) && FamiliarRingItem.getCurio(stack).captureFamiliar(playerIn.level(), familiar)) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)playerIn, FamiliarTrigger.Type.CAPTURE);
            stack.set(OccultismDataComponents.OCCUPIED, (Object)true);
            ItemNBTUtil.setBoundSpiritName(stack, familiar.getFamiliarEntity().getDisplayName().getString());
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, playerIn, target, hand);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getPlayer().getItemInHand(pContext.getHand());
        if (!pContext.getPlayer().level().isClientSide && FamiliarRingItem.getCurio(stack).releaseFamiliar(pContext.getPlayer(), pContext.getLevel())) {
            stack.set(OccultismDataComponents.OCCUPIED, (Object)false);
            return InteractionResult.sidedSuccess((boolean)pContext.getPlayer().level().isClientSide);
        }
        return InteractionResult.CONSUME;
    }

    public void verifyComponentsAfterLoad(ItemStack pStack) {
        super.verifyComponentsAfterLoad(pStack);
        this.handleFamiliarTypeTag(pStack);
    }

    public void handleFamiliarTypeTag(ItemStack pStack) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ICurio icurio = (ICurio)pStack.getCapability(CuriosCapability.ITEM);
        if (pStack.has(OccultismDataComponents.FAMILIAR_TYPE) && icurio instanceof Curio) {
            Curio curio = (Curio)icurio;
            if (server != null) {
                try {
                    ServerLevel level;
                    Entity entity;
                    IFamiliar familiar;
                    EntityType type = BuiltInRegistries.ENTITY_TYPE.getOptional((ResourceLocation)pStack.get(OccultismDataComponents.FAMILIAR_TYPE)).orElse(null);
                    if (type != null && (familiar = (IFamiliar)(entity = type.create((Level)(level = ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD))))) != null) {
                        curio.setFamiliar(familiar, (HolderLookup.Provider)server.registryAccess());
                        pStack.set(OccultismDataComponents.OCCUPIED, (Object)true);
                        pStack.set(OccultismDataComponents.FAMILIAR_DATA, (Object)CustomData.of((CompoundTag)curio.serializeNBT((HolderLookup.Provider)server.registryAccess())));
                    }
                    pStack.remove(OccultismDataComponents.FAMILIAR_TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class Curio
    implements ICurio,
    INBTSerializable<CompoundTag> {
        private final ItemStack stack;
        private IFamiliar familiar;
        private CompoundTag cachedNbt;

        public Curio(ItemStack stack) {
            this.stack = stack;
        }

        private boolean captureFamiliar(Level level, IFamiliar familiar) {
            if (this.getFamiliar(level) != null) {
                return false;
            }
            familiar.getFamiliarEntity().onRemovedFromLevel();
            this.setFamiliar(familiar, (HolderLookup.Provider)level.registryAccess());
            this.getFamiliar(level).getFamiliarEntity().stopRiding();
            this.getFamiliar(level).getFamiliarEntity().ejectPassengers();
            this.getFamiliar(level).getFamiliarEntity().remove(Entity.RemovalReason.DISCARDED);
            return true;
        }

        private boolean releaseFamiliar(Player player, Level level) {
            if (this.getFamiliar(level) != null && !this.getFamiliar(level).getFamiliarEntity().isAddedToLevel()) {
                CompoundTag familiarTag = new CompoundTag();
                this.getFamiliar(level).getFamiliarEntity().saveAsPassenger(familiarTag);
                EntityType.loadEntityRecursive((CompoundTag)familiarTag, (Level)level, e -> {
                    e.setPos(player.getX(), player.getY(), player.getZ());
                    ((IFamiliar)e).setFamiliarOwner((LivingEntity)player);
                    String name = ItemNBTUtil.getBoundSpiritName(this.stack);
                    e.setCustomName((Component)Component.literal((String)name));
                    level.addFreshEntity(e);
                    return e;
                });
                this.setFamiliar(null, (HolderLookup.Provider)level.registryAccess());
                return true;
            }
            return false;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            Level level = slotContext.entity().level();
            IFamiliar familiar = this.getFamiliar(level);
            if (familiar != null) {
                if (!familiar.getFamiliarEntity().isAddedToLevel()) {
                    familiar.getFamiliarEntity().setLevel(level);
                }
                if (familiar.getFamiliarOwner() != slotContext.entity()) {
                    return;
                }
                if (!level.isClientSide && slotContext.entity().tickCount % 20 == 0 && familiar.isEffectEnabled(slotContext.entity())) {
                    for (MobEffectInstance effect : familiar.getFamiliarEffects()) {
                        familiar.getFamiliarOwner().addEffect(effect);
                    }
                }
                familiar.curioTick(slotContext.entity());
            }
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag compound = new CompoundTag();
            compound.putBoolean("hasFamiliar", this.familiar != null || this.cachedNbt != null);
            if (this.familiar != null) {
                CompoundTag familiarTag = new CompoundTag();
                this.familiar.getFamiliarEntity().saveAsPassenger(familiarTag);
                compound.put("familiar", (Tag)familiarTag);
            } else if (this.cachedNbt != null) {
                compound.put("familiar", (Tag)this.cachedNbt);
            }
            return compound;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compound) {
            if (compound.getBoolean("hasFamiliar")) {
                this.cachedNbt = compound.getCompound("familiar");
            }
        }

        private IFamiliar getFamiliar(Level level) {
            CompoundTag tag;
            if (this.familiar != null) {
                return this.familiar;
            }
            CustomData data = (CustomData)this.stack.get(OccultismDataComponents.FAMILIAR_DATA);
            CompoundTag compoundTag = tag = data == null ? null : data.getUnsafe();
            if (!(tag == null || this.cachedNbt != null && this.cachedNbt.equals((Object)tag))) {
                this.deserializeNBT((HolderLookup.Provider)level.registryAccess(), tag);
            }
            if (this.cachedNbt != null) {
                this.familiar = (IFamiliar)EntityType.loadEntityRecursive((CompoundTag)this.cachedNbt, (Level)level, Function.identity());
                return this.familiar;
            }
            return this.familiar;
        }

        private void setFamiliar(IFamiliar familiar, HolderLookup.Provider provider) {
            this.familiar = familiar;
            CompoundTag compound = new CompoundTag();
            this.cachedNbt = this.familiar != null ? (this.familiar.getFamiliarEntity().saveAsPassenger(compound) ? compound : null) : null;
            this.stack.set(OccultismDataComponents.FAMILIAR_DATA, (Object)CustomData.of((CompoundTag)this.serializeNBT(provider)));
        }
    }

    public static class DistHelper {
        public static void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag flagIn) {
            IFamiliar familiar;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && (familiar = FamiliarRingItem.getFamiliar(stack, (Level)level)) != null) {
                EntityType type = familiar.getFamiliarEntity().getType();
                tooltip.add((Component)Component.translatable((String)(stack.getDescriptionId() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack)), Component.translatable((String)(stack.getDescriptionId() + ".tooltip.familiar_type"), (Object[])new Object[]{TextUtil.formatDemonType(type.getDescription(), type)}).withStyle(ChatFormatting.ITALIC)}));
            }
        }

        public static boolean isFoil(ItemStack pStack) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return false;
            }
            IFamiliar familiar = FamiliarRingItem.getFamiliar(pStack, (Level)level);
            if (familiar != null) {
                return familiar.isEffectEnabled((LivingEntity)Minecraft.getInstance().player);
            }
            return false;
        }
    }
}

