/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.possessed.horde;

import com.klikli_dev.occultism.common.entity.possessed.PossessedMob;
import com.klikli_dev.occultism.common.entity.possessed.horde.WildHuntWitherSkeletonEntity;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WildHuntSkeletonEntity
extends Skeleton
implements PossessedMob {
    protected Optional<WildHuntWitherSkeletonEntity> master = Optional.empty();

    public WildHuntSkeletonEntity(EntityType<? extends WildHuntSkeletonEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Skeleton.createAttributes().add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MAX_HEALTH, 20.0);
    }

    public void setMaster(WildHuntWitherSkeletonEntity master) {
        this.master = Optional.ofNullable(master);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance pDifficulty) {
        super.populateDefaultEquipmentSlots(randomSource, pDifficulty);
        if (this.random.nextFloat() <= 0.7f) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_SWORD));
        }
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    protected boolean isSunBurnTick() {
        return false;
    }

    public void remove(Entity.RemovalReason reason) {
        this.master.ifPresent(boss -> boss.notifyMinionDeath(this));
        super.remove(reason);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        TagKey<EntityType<?>> wildHuntTag = OccultismTags.Entities.WILD_HUNT;
        Entity trueSource = source.getEntity();
        if (trueSource != null && trueSource.getType().is(wildHuntTag)) {
            return true;
        }
        Entity immediateSource = source.getDirectEntity();
        if (immediateSource != null && immediateSource.getType().is(wildHuntTag)) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    @Override
    public EntityType basedMob() {
        return EntityType.SKELETON;
    }
}

