/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.util.FamiliarUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class ShubNiggurathSpawnEntity
extends PathfinderMob {
    private static final int EYE_COUNT = 4;
    private static final int LIFE_TICKS_MAX = 400;
    private final int[] eyeBlinkTimers = new int[4];
    private int lifeTicks = 400;
    private UUID creatorId;

    public ShubNiggurathSpawnEntity(EntityType<? extends ShubNiggurathSpawnEntity> type, Level level) {
        super(type, level);
    }

    public ShubNiggurathSpawnEntity(Level level, LivingEntity creator) {
        this(OccultismEntities.SHUB_NIGGURATH_SPAWN.get(), level);
        this.creatorId = creator.getUUID();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MoveToTargetGoal(this));
        this.targetSelector.addGoal(0, (Goal)new FindEnemiesGoal(this));
        this.targetSelector.addGoal(1, (Goal)new FindCreatorGoal(this));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.lifeTicks-- < 0) {
                this.explode();
            }
            if (this.lifeTicks % 10 == 0 && !FamiliarUtil.getOwnerEnemies(this.getCreatorOwner(), (LivingEntity)this, 10.0f).isEmpty()) {
                this.explode();
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                int n = i;
                this.eyeBlinkTimers[n] = this.eyeBlinkTimers[n] - 1;
                if (this.eyeBlinkTimers[i] >= 0) continue;
                this.eyeBlinkTimers[i] = this.getRandom().nextInt(100) + 50;
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("lifeTicks", this.lifeTicks);
        if (this.creatorId != null) {
            pCompound.putUUID("creatorId", this.creatorId);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("lifeTicks")) {
            this.lifeTicks = pCompound.getInt("lifeTicks");
        }
        if (pCompound.hasUUID("creatorId")) {
            this.creatorId = pCompound.getUUID("creatorId");
        }
    }

    public boolean isBlinking(int eye) {
        return this.eyeBlinkTimers[eye] < 3;
    }

    private void explode() {
        if (!this.isAlive()) {
            return;
        }
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        LivingEntity owner = this.getCreatorOwner();
        List<LivingEntity> enemies = FamiliarUtil.getOwnerEnemies(owner, (LivingEntity)this, 10.0f);
        for (LivingEntity e : enemies) {
            e.hurt(owner == null ? this.damageSources().generic() : this.damageSources().mobAttack(owner), damage);
        }
        if (!enemies.isEmpty()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(this.getCreatorOwner(), FamiliarTrigger.Type.SHUB_NIGGURATH_SPAWN);
        }
        this.kill();
    }

    private LivingEntity getCreator() {
        if (this.creatorId == null) {
            return null;
        }
        Entity creator = ((ServerLevel)this.level()).getEntity(this.creatorId);
        if (!(creator instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)creator;
    }

    private LivingEntity getCreatorOwner() {
        LivingEntity creator = this.getCreator();
        if (creator instanceof IFamiliar) {
            return ((IFamiliar)creator).getFamiliarOwner();
        }
        return creator;
    }

    public void die(DamageSource pCause) {
        super.die(pCause);
        if (this.level().isClientSide) {
            for (int i = 0; i < 30; ++i) {
                this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 0.0f), 1.0f), this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 0.0, 1.0, 0.0);
            }
        }
    }

    private static class MoveToTargetGoal
    extends Goal {
        private final ShubNiggurathSpawnEntity entity;
        private int timer;

        private MoveToTargetGoal(ShubNiggurathSpawnEntity entity) {
            this.entity = entity;
        }

        public boolean canUse() {
            LivingEntity target = this.entity.getTarget();
            return target != null && target.isAlive();
        }

        public void stop() {
            this.entity.getNavigation().stop();
        }

        public void tick() {
            if (this.timer-- < 0) {
                this.timer = 20;
                LivingEntity target = this.entity.getTarget();
                if (target != null) {
                    this.entity.getNavigation().moveTo((Entity)target, 1.0);
                }
            }
        }
    }

    private static class FindEnemiesGoal
    extends FindTargetGoal {
        private FindEnemiesGoal(ShubNiggurathSpawnEntity entity) {
            super(entity);
        }

        @Override
        protected LivingEntity findTarget() {
            List<LivingEntity> enemies = FamiliarUtil.getOwnerEnemies(this.entity.getCreatorOwner(), (LivingEntity)this.entity, 30.0f);
            if (!enemies.isEmpty()) {
                return enemies.get(0);
            }
            return null;
        }
    }

    private static class FindCreatorGoal
    extends FindTargetGoal {
        private FindCreatorGoal(ShubNiggurathSpawnEntity entity) {
            super(entity);
        }

        @Override
        protected LivingEntity findTarget() {
            return this.entity.getCreator();
        }
    }

    private static abstract class FindTargetGoal
    extends TargetGoal {
        protected ShubNiggurathSpawnEntity entity;

        private FindTargetGoal(ShubNiggurathSpawnEntity entity) {
            super((Mob)entity, false);
            this.entity = entity;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        protected abstract LivingEntity findTarget();

        public void start() {
            LivingEntity target = this.findTarget();
            if (target != null) {
                this.entity.setTarget(target);
            }
            super.start();
        }

        public boolean canUse() {
            return this.findTarget() != null;
        }
    }
}

