/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.sensor;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSelectBlock;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.registry.OccultismSensors;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class NearestJobItemSensor<E extends SpiritEntity>
extends PredicateSensor<ItemEntity, E> {
    public static final int DEFAULT_SCAN_RATE_TICKS = 20;
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM});

    public NearestJobItemSensor() {
        super((item, entity) -> entity.canPickupItem((ItemEntity)item) && entity.hasLineOfSight((Entity)item));
        this.setScanRate(entity -> 20);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return OccultismSensors.NEAREST_JOB_ITEM.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        if (BrainUtils.hasMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM)) {
            ItemEntity nearestEntity = (ItemEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
            if (Occultism.DEBUG.debugAI) {
                Networking.sendToTracking(entity, new MessageSelectBlock(nearestEntity.blockPosition(), 5000, 65280));
            }
            return;
        }
        BlockPos workAreaCenter = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_CENTER.get());
        Integer workAreaSize = (Integer)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_SIZE.get());
        if (Occultism.DEBUG.debugAI) {
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter, 5000, 255));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(workAreaSize / 2, workAreaSize / 2, workAreaSize / 2), 5000, 65535));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(-workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2), 5000, 65535));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(workAreaSize / 2, workAreaSize / 2, -workAreaSize.intValue() / 2), 5000, 65535));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(-workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2, workAreaSize / 2), 5000, 65535));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(workAreaSize / 2, -workAreaSize.intValue() / 2, workAreaSize / 2), 5000, 65535));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(-workAreaSize.intValue() / 2, workAreaSize / 2, -workAreaSize.intValue() / 2), 5000, 65535));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(-workAreaSize.intValue() / 2, workAreaSize / 2, workAreaSize / 2), 5000, 65535));
            Networking.sendToTracking(entity, new MessageSelectBlock(workAreaCenter.offset(workAreaSize / 2, -workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2), 5000, 65535));
        }
        AABB aabb = new AABB(workAreaCenter.getCenter().add((double)((float)(-workAreaSize.intValue()) / 2.0f), (double)((float)(-workAreaSize.intValue()) / 2.0f), (double)((float)(-workAreaSize.intValue()) / 2.0f)), workAreaCenter.getCenter().add((double)((float)workAreaSize.intValue() / 2.0f), (double)((float)workAreaSize.intValue() / 2.0f), (double)((float)workAreaSize.intValue() / 2.0f)));
        ItemEntity nearestEntity = (ItemEntity)EntityRetrievalUtil.getNearestEntity((Level)level, (AABB)aabb, (Vec3)entity.position(), obj -> {
            if (obj instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)obj;
                return this.predicate().test(item, entity);
            }
            return false;
        });
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)nearestEntity);
        if (Occultism.DEBUG.debugAI && nearestEntity != null) {
            Networking.sendToTracking(entity, new MessageSelectBlock(nearestEntity.blockPosition(), 5000, 65280));
        }
    }
}

