/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageUpdateLinkedMachines;
import com.klikli_dev.occultism.registry.OccultismContainers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StorageControllerContainer
extends StorageControllerContainerBase {
    protected StorageControllerBlockEntity storageController;

    public StorageControllerContainer(int id, Inventory playerInventory, StorageControllerBlockEntity storageController) {
        super(OccultismContainers.STORAGE_CONTROLLER.get(), id, playerInventory);
        this.storageController = storageController;
        this.matrix = new StorageControllerCraftingInventory((AbstractContainerMenu)this, storageController.getMatrix());
        this.orderInventory.setItem(0, storageController.getOrderStack());
        this.setupCraftingOutput();
        this.setupCraftingGrid();
        this.setupOrderInventorySlot();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
        this.slotsChanged((Container)this.matrix);
    }

    @Override
    public StorageControllerBlockEntity getStorageController() {
        return this.storageController;
    }

    @Override
    public boolean isContainerItem() {
        return false;
    }

    @Override
    public void updateCraftingSlots(boolean force) {
        for (int i = 0; i < 9; ++i) {
            this.storageController.getMatrix().put(i, this.matrix.getItem(i));
        }
        if (force) {
            this.storageController.markNetworkDirty();
        }
    }

    @Override
    public void updateOrderSlot(boolean force) {
        this.storageController.setOrderStack(this.orderInventory.getItem(0));
        if (force) {
            this.storageController.markNetworkDirty();
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.result && super.canTakeItemForPickAll(stack, slot);
    }

    public boolean stillValid(Player player) {
        BlockPos controllerPosition;
        if (this.storageController == null) {
            return false;
        }
        Level level = this.storageController.getLevel();
        if (level.getBlockEntity(controllerPosition = this.storageController.getBlockPos()) != this.storageController) {
            return false;
        }
        if (!level.isClientSide && level.getGameTime() % 40L == 0L) {
            Networking.sendTo((ServerPlayer)player, this.storageController.getMessageUpdateStacks());
            Networking.sendTo((ServerPlayer)player, new MessageUpdateLinkedMachines(this.storageController.getLinkedMachines()));
        }
        return player.distanceToSqr((double)controllerPosition.getX() + 0.5, (double)controllerPosition.getY() + 0.5, (double)controllerPosition.getZ() + 0.5) <= 64.0;
    }
}

