/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class NetworkedBlockEntity
extends BlockEntity {
    public NetworkedBlockEntity(BlockEntityType<?> BlockEntityTypeIn, BlockPos worldPos, BlockState state) {
        super(BlockEntityTypeIn, worldPos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.loadNetwork(compound, provider);
        super.loadAdditional(compound, provider);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.saveNetwork(compound, provider);
        super.saveAdditional(compound, provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveNetwork(super.getUpdateTag(provider), provider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadNetwork(pkt.getTag(), lookupProvider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.loadNetwork(tag, provider);
    }

    public void loadNetwork(CompoundTag compound, HolderLookup.Provider provider) {
    }

    public CompoundTag saveNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        return compound;
    }

    public void markNetworkDirty() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }
}

