/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StorageStabilizerBlock
extends Block {
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.EAST, (Object)Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 0.3, 1.0, 1.0))).put((Object)Direction.WEST, (Object)Shapes.create((AABB)new AABB(0.7, 0.0, 0.0, 1.0, 1.0, 1.0))).put((Object)Direction.NORTH, (Object)Shapes.create((AABB)new AABB(0.0, 0.0, 0.7, 1.0, 1.0, 1.0))).put((Object)Direction.SOUTH, (Object)Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.3))).put((Object)Direction.UP, (Object)Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0))).put((Object)Direction.DOWN, (Object)Shapes.create((AABB)new AABB(0.0, 0.7, 0.0, 1.0, 1.0, 1.0))).build());

    public StorageStabilizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState) {
            this.notifyStorageControllers(level, pos, state);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)BlockStateProperties.FACING));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace());
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, state, te, stack);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.notifyStorageControllers(level, pos, state);
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
        super.createBlockStateDefinition(builder);
    }

    public void notifyStorageControllers(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        BlockPos min = facing != Direction.DOWN && facing != Direction.UP ? pos.below() : pos;
        List<BlockPos> blocks = Math3DUtil.simpleTrace(min, facing, 5);
        for (BlockPos block : blocks) {
            BlockEntity blockEntity = level.getBlockEntity(block);
            if (!(blockEntity instanceof StorageControllerBlockEntity)) continue;
            StorageControllerBlockEntity controller = (StorageControllerBlockEntity)blockEntity;
            controller.updateStabilizers();
        }
    }
}

