/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.spirit.wonderingtrader.WonderingTraderEntity;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.util.CuriosUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WonderingTraderModel
extends DefaultedGeoModel<WonderingTraderEntity> {
    public WonderingTraderModel() {
        super(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"wondering_trader"));
    }

    protected String subtype() {
        return "entity";
    }

    public RenderType getRenderType(WonderingTraderEntity animatable, ResourceLocation texture) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureResource((GeoAnimatable)animatable));
    }

    public void setCustomAnimations(WonderingTraderEntity entity, long instanceId, AnimationState<WonderingTraderEntity> animationState) {
        GeoBone head3;
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        GeoBone common = this.getAnimationProcessor().getBone("common");
        if (common == null) {
            return;
        }
        GeoBone other = this.getAnimationProcessor().getBone("other");
        if (other == null) {
            return;
        }
        GeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
            head.setRotX(-entityData.headPitch() * ((float)Math.PI / 180));
        }
        if ((head3 = this.getAnimationProcessor().getBone("head3")) != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head3.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
            head3.setRotX(-entityData.headPitch() * ((float)Math.PI / 180));
        }
        boolean hidden = player.hasEffect(OccultismEffects.THIRD_EYE) || CuriosUtil.hasGoggles((Player)player) || CuriosUtil.hasStaff((Player)player);
        this.hideChildrenRecursive(common, hidden);
        this.hideChildrenRecursive(other, !hidden);
    }

    private void hideChildrenRecursive(GeoBone bone, boolean hide) {
        for (GeoBone child : bone.getChildBones()) {
            child.setHidden(hide);
            this.hideChildrenRecursive(child, hide);
        }
    }
}

