/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.spirit;

import com.klikli_dev.occultism.client.gui.controls.SizedImageButton;
import com.klikli_dev.occultism.client.gui.spirit.SpiritGui;
import com.klikli_dev.occultism.common.container.spirit.SpiritTransporterContainer;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSetFilterMode;
import com.klikli_dev.occultism.network.messages.MessageSetTagFilterText;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.StringUtils;

public class SpiritTransporterGui
extends SpiritGui<SpiritTransporterContainer> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/inventory_spirit_transporter_tagfilter.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.spirit.transporter";
    protected final List<Component> tooltip = new ArrayList<Component>();
    protected SpiritTransporterContainer container;
    protected SizedImageButton filterModeButton;
    protected EditBox tagFilterTextField;
    protected String tagFilter;

    public SpiritTransporterGui(SpiritTransporterContainer container, Inventory playerInventory, Component titleIn) {
        super(container, playerInventory, titleIn);
        this.container = container;
        this.imageWidth = 176;
        this.imageHeight = 220;
    }

    public boolean isBlacklist() {
        return this.spirit.isFilterBlacklist();
    }

    public String getTagFilterText() {
        return this.tagFilter;
    }

    public void setTagFilterText(String tagFilterText) {
        this.tagFilter = tagFilterText;
    }

    public void setIsBlacklist(boolean isBlacklist) {
        this.spirit.setFilterBlacklist(isBlacklist);
        Networking.sendToServer(new MessageSetFilterMode(isBlacklist, this.spirit.getId()));
    }

    @Override
    public void init() {
        super.init();
        this.setTagFilterText(this.spirit.getTagFilter());
        int isBlacklistButtonTop = 83;
        int isBlacklistButtonLeft = 151;
        int buttonSize = 18;
        int isBlacklistOffset = (this.isBlacklist() ? 0 : 1) * 20;
        this.filterModeButton = new SizedImageButton(this.leftPos + isBlacklistButtonLeft, this.topPos + isBlacklistButtonTop, buttonSize, buttonSize, 177, isBlacklistOffset, 20, 20, 20, 256, 256, TEXTURE, button -> {
            this.setIsBlacklist(!this.isBlacklist());
            this.init();
        });
        this.addRenderableWidget((GuiEventListener)this.filterModeButton);
        int tagFilterLeft = 8;
        int tagFilterTop = 123;
        int tagFilterWidth = 124;
        Objects.requireNonNull(this.font);
        this.tagFilterTextField = new EditBox(this.font, this.leftPos + tagFilterLeft, this.topPos + tagFilterTop, tagFilterWidth, 9, (Component)Component.literal((String)"c:ores;*logs*;item:minecraft:chest"));
        this.tagFilterTextField.setMaxLength(90);
        this.tagFilterTextField.setBordered(false);
        this.tagFilterTextField.setVisible(true);
        this.tagFilterTextField.setTextColor(0xFFFFFF);
        this.tagFilterTextField.setFocused(false);
        if (!StringUtils.isBlank((CharSequence)this.getTagFilterText())) {
            this.tagFilterTextField.setValue(this.getTagFilterText());
        }
        this.addWidget((GuiEventListener)this.tagFilterTextField);
        this.setInitialFocus((GuiEventListener)this.tagFilterTextField);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        int scale = 30;
        SpiritTransporterGui.drawEntityToGui(guiGraphics, this.leftPos + 35, this.topPos + 65, scale, this.leftPos + 51 - x, this.topPos + 75 - 50 - y, (LivingEntity)this.spirit);
        guiGraphics.pose().popPose();
    }

    protected void renderFg(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.tooltip.clear();
        if (this.filterModeButton.isHoveredOrFocused()) {
            this.tooltip.add((Component)Component.translatable((String)"gui.occultism.spirit.transporter.filter_mode"));
            this.tooltip.add((Component)Component.translatable((String)("gui.occultism.spirit.transporter.filter_mode." + (this.isBlacklist() ? "blacklist" : "whitelist"))).withStyle(ChatFormatting.GRAY));
        }
        if (this.isPointInSearchbar(mouseX, mouseY)) {
            this.tooltip.add((Component)Component.translatable((String)"gui.occultism.spirit.transporter.tag_filter"));
        }
        if (!this.tooltip.isEmpty()) {
            guiGraphics.renderTooltip(this.font, this.tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.tagFilterTextField.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderFg(guiGraphics, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isPointInSearchbar(mouseX, mouseY) && mouseButton == 1) {
            this.tagFilterTextField.setValue("");
            this.setTagFilterText("");
        }
        if (this.tagFilterTextField.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey;
        this.setTagFilterText(this.tagFilterTextField.getValue());
        if (this.tagFilterTextField.isFocused() && this.tagFilterTextField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.tagFilterTextField.isFocused() && this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        super.onClose();
        this.tagFilterTextField.setFocused(false);
        this.spirit.setTagFilter(this.tagFilter);
        Networking.sendToServer(new MessageSetTagFilterText(this.tagFilter, this.spirit.getId()));
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.tagFilterTextField.isFocused() && this.tagFilterTextField.charTyped(codePoint, modifiers)) {
            this.setTagFilterText(this.tagFilterTextField.getValue());
        }
        return false;
    }

    protected boolean isPointInSearchbar(double mouseX, double mouseY) {
        int n = this.tagFilterTextField.getX() - this.leftPos;
        int n2 = this.tagFilterTextField.getY() - this.topPos;
        int n3 = this.tagFilterTextField.getWidth() - 5;
        Objects.requireNonNull(this.font);
        return this.isHovering(n, n2, n3, 9 + 6, mouseX, mouseY);
    }
}

