/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.klikli_dev.occultism.network.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MessageFairySupport
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"fairy_support");
    public static final CustomPacketPayload.Type<MessageFairySupport> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageFairySupport> STREAM_CODEC = CustomPacketPayload.codec(MessageFairySupport::encode, MessageFairySupport::new);
    private int fairyId;
    private int targetId;

    public MessageFairySupport(int fairyId, int targetId) {
        this.fairyId = fairyId;
        this.targetId = targetId;
    }

    public MessageFairySupport(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.fairyId);
        buf.writeInt(this.targetId);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.fairyId = buf.readInt();
        this.targetId = buf.readInt();
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Entity target;
        Entity fairy = minecraft.level.getEntity(this.fairyId);
        if (fairy instanceof FairyFamiliarEntity) {
            ((FairyFamiliarEntity)fairy).startSupportAnimation();
        }
        if ((target = minecraft.level.getEntity(this.targetId)) != null) {
            for (int i = 0; i < 30; ++i) {
                Vec3 pos = new Vec3(target.getRandomX(1.0), target.getRandomY(), target.getRandomZ(1.0));
                minecraft.level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.9f, 0.5f), 1.0f), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

