/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.impl.recipes;

import com.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import com.klikli_dev.occultism.crafting.recipe.input.ItemHandlerRecipeInput;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.integration.jei.impl.JeiRecipeTypes;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MinerRecipeCategory
implements IRecipeCategory<RecipeHolder<MinerRecipe>> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final Map<MinerRecipe, Float> chances = new HashMap<MinerRecipe, Float>();

    public MinerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 46);
        this.localizedName = Component.translatable((String)"occultism.jei.miner");
        this.overlay = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, Component text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.width((FormattedText)text) / 2.0f, (float)y, 0, false);
    }

    public RecipeType<RecipeHolder<MinerRecipe>> getRecipeType() {
        return JeiRecipeTypes.MINER;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<MinerRecipe> recipe, IFocusGroup focuses) {
        ClientLevel level = Minecraft.getInstance().level;
        ItemStackHandler simulatedHandler = new ItemStackHandler(1);
        simulatedHandler.setStackInSlot(0, ((Ingredient)((MinerRecipe)recipe.value()).getIngredients().get(0)).getItems()[0]);
        List recipes = level.getRecipeManager().getRecipesFor((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.MINER_TYPE.get(), (RecipeInput)new ItemHandlerRecipeInput((IItemHandlerModifiable)simulatedHandler), (Level)level);
        List<WeightedRecipeResult> possibleResults = recipes.stream().map(RecipeHolder::value).map(MinerRecipe::getWeightedResult).toList();
        float chance = (float)((MinerRecipe)recipe.value()).getWeightedResult().getWeight().asInt() / 100.0f;
        this.chances.put((MinerRecipe)recipe.value(), Float.valueOf(chance));
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 12).addIngredients((Ingredient)((MinerRecipe)recipe.value()).getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 12).addItemStack(((MinerRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    public void draw(RecipeHolder<MinerRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(guiGraphics, 76, 14);
        this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"occultism.jei.miner.chance", (Object[])new Object[]{this.chances.get(recipe.value())}), 84, 0);
    }
}

