/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.ritual;

import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CommandRitual
extends Ritual {
    public CommandRitual(RitualRecipe recipe) {
        super(recipe);
    }

    @Override
    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, @Nullable ServerPlayer castingPlayer, ItemStack activationItem) {
        super.finish(level, goldenBowlPosition, blockEntity, castingPlayer, activationItem);
        activationItem.shrink(1);
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)goldenBowlPosition.getX() + 0.5, (double)goldenBowlPosition.getY() + 0.5, (double)goldenBowlPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        if (this.recipe.getCommand() != null) {
            this.execute(this.recipe.getCommand(), (ServerLevel)level, goldenBowlPosition, (Player)castingPlayer);
        }
        ItemStack flame = OccultismItems.FLAME_AUTOMATION.toStack();
        ItemNBTUtil.setBoundSpiritName(flame, this.recipe.getRitualDummy().toString().substring(2).replace("occultism:ritual_dummy/", ""));
        this.dropResult(level, goldenBowlPosition, blockEntity, (Player)castingPlayer, flame, false);
    }

    private void execute(String command, ServerLevel level, BlockPos pos, Player castingPlayer) {
        MinecraftServer minecraftserver = level.getServer();
        MutableComponent name = Component.literal((String)"@");
        try {
            CommandSourceStack commandsourcestack = new CommandSourceStack(CommandSource.NULL, Vec3.atCenterOf((Vec3i)pos), Vec2.ZERO, level, 2, name.getString(), (Component)name, minecraftserver, (Entity)castingPlayer);
            minecraftserver.getCommands().performPrefixedCommand(commandsourcestack, command);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Executing command block");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Command to be executed");
            crashreportcategory.setDetail("Command", () -> command);
            crashreportcategory.setDetail("Name", () -> ((MutableComponent)name).getString());
            throw new ReportedException(crashreport);
        }
    }
}

