/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.LivingEntity;

public interface ISkinnedCreatureMixin {
    default public LivingEntity getEntity() {
        return (LivingEntity)this;
    }

    public EntityDataAccessor<Integer> getDataParameterSkin();

    default public int getSkinTypes() {
        return 1;
    }

    default public void writeSkinToNBT(CompoundTag tag) {
        SynchedEntityData entityData = this.getEntity().getEntityData();
        tag.putInt("skin", ((Integer)entityData.get(this.getDataParameterSkin())).intValue());
    }

    default public void readSkinFromNBT(CompoundTag tag) {
        SynchedEntityData entityData = this.getEntity().getEntityData();
        entityData.set(this.getDataParameterSkin(), (Object)tag.getInt("skin"));
    }

    default public void selectRandomSkin() {
        SynchedEntityData entityData = this.getEntity().getEntityData();
        entityData.set(this.getDataParameterSkin(), (Object)this.getEntity().getRandom().nextInt(this.getSkinTypes()));
    }

    default public void registerSkinDataParameter(SynchedEntityData.Builder builder) {
        builder.define(this.getDataParameterSkin(), (Object)0);
    }
}

