/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.klikli_dev.occultism.common.entity.ai.goal.PausableGoal;
import com.klikli_dev.occultism.common.entity.ai.target.BlockPosMoveTarget;
import com.klikli_dev.occultism.common.entity.ai.target.EntityMoveTarget;
import com.klikli_dev.occultism.common.entity.ai.target.IMoveTarget;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DepositItemsGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected IMoveTarget moveTarget = null;

    public DepositItemsGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.position(), Math3DUtil.center(this.moveTarget.getBlockPos()));
        return this.moveTarget.getBlockPos().relative(Direction.fromYRot((double)angle).getOpposite());
    }

    @Override
    public boolean canUse() {
        if (this.entity.getTarget() != null) {
            return false;
        }
        if (this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            return false;
        }
        this.resetTarget();
        return !this.isPaused() && this.moveTarget != null;
    }

    @Override
    public boolean canContinueToUse() {
        return !this.isPaused() && this.moveTarget != null && !this.entity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty();
    }

    public void stop() {
        this.entity.getNavigation().stop();
        this.resetTarget();
    }

    public void tick() {
        if (this.moveTarget != null) {
            if (this.moveTarget.isValid()) {
                float accessDistance = 2.2f;
                double distance = this.entity.position().distanceTo(Math3DUtil.center(this.moveTarget.getBlockPos()));
                if (distance < 2.5 && distance >= (double)accessDistance && this.canSeeTarget() && this.moveTarget.isChest()) {
                    this.toggleChest(this.moveTarget, true);
                }
                if (distance < (double)accessDistance) {
                    this.entity.getNavigation().stop();
                } else {
                    BlockPos moveTarget = this.getMoveTarget();
                    this.entity.getNavigation().moveTo(this.entity.getNavigation().createPath(moveTarget, 0), 1.0);
                }
                if (distance < (double)accessDistance && this.canSeeTarget()) {
                    IItemHandler handler = this.moveTarget.getItemHandler(this.entity.getDepositFacing());
                    if (handler == null) {
                        this.resetTarget();
                        return;
                    }
                    ItemStack duplicate = this.entity.getItemInHand(InteractionHand.MAIN_HAND).copy();
                    ItemStack toInsert = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)duplicate, (boolean)true);
                    if (toInsert.getCount() != duplicate.getCount()) {
                        ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                        this.entity.setItemInHand(InteractionHand.MAIN_HAND, leftover);
                        if (toInsert.isEmpty()) {
                            this.moveTarget = null;
                            this.stop();
                        } else {
                            this.pause(2000L);
                        }
                    }
                    if (this.moveTarget != null && this.moveTarget.isChest()) {
                        this.toggleChest(this.moveTarget, false);
                    }
                }
            } else {
                this.resetTarget();
            }
        }
    }

    public boolean canSeeTarget() {
        return true;
    }

    public void toggleChest(IMoveTarget target, boolean open) {
        BlockEntity blockEntity;
        if (target instanceof BlockPosMoveTarget && (blockEntity = this.entity.level().getBlockEntity(target.getBlockPos())) instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            if (open) {
                this.entity.level().blockEvent(this.moveTarget.getBlockPos(), chest.getBlockState().getBlock(), 1, 1);
            } else {
                this.entity.level().blockEvent(this.moveTarget.getBlockPos(), chest.getBlockState().getBlock(), 1, 0);
            }
        }
    }

    private void resetTarget() {
        Optional<BlockPos> targetPos = this.entity.getDepositPosition();
        targetPos.ifPresent(pos -> {
            this.moveTarget = new BlockPosMoveTarget(this.entity.level(), (BlockPos)pos);
            IItemHandler handler = (IItemHandler)this.entity.level().getCapability(Capabilities.ItemHandler.BLOCK, this.moveTarget.getBlockPos(), (Object)this.entity.getDepositFacing());
            if (handler == null) {
                this.entity.setDepositPosition(null);
            }
        });
        Optional<UUID> targetUUID = this.entity.getDepositEntityUUID();
        targetUUID.ifPresent(uuid -> {
            Entity targetEntity = ((ServerLevel)this.entity.level()).getEntity(uuid);
            if (targetEntity != null) {
                this.moveTarget = new EntityMoveTarget(targetEntity);
            } else {
                this.entity.setDepositEntityUUID(null);
            }
        });
    }
}

