/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.ShubNiggurathSpawnModel;
import com.klikli_dev.occultism.common.entity.familiar.ShubNiggurathSpawnEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ShubNiggurathSpawnRenderer
extends MobRenderer<ShubNiggurathSpawnEntity, ShubNiggurathSpawnModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/shub_niggurath_spawn.png");

    public ShubNiggurathSpawnRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ShubNiggurathSpawnModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_SHUB_NIGGURATH_SPAWN)), 0.1f);
        this.addLayer(new BlinkingEyesLayer((RenderLayerParent<ShubNiggurathSpawnEntity, ShubNiggurathSpawnModel>)this, context));
    }

    public ResourceLocation getTextureLocation(ShubNiggurathSpawnEntity entity) {
        return TEXTURES;
    }

    private static class BlinkingEyesLayer
    extends RenderLayer<ShubNiggurathSpawnEntity, ShubNiggurathSpawnModel> {
        private static final ResourceLocation BLINKING = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/shub_niggurath_spawn_blinking.png");
        private final ShubNiggurathSpawnModel model;

        public BlinkingEyesLayer(RenderLayerParent<ShubNiggurathSpawnEntity, ShubNiggurathSpawnModel> parent, EntityRendererProvider.Context context) {
            super(parent);
            this.model = new ShubNiggurathSpawnModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_SHUB_NIGGURATH_SPAWN));
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, ShubNiggurathSpawnEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!pLivingEntity.isInvisible()) {
                ((ShubNiggurathSpawnModel)this.getParentModel()).copyPropertiesTo(this.model);
                this.model.prepareMobModel((Entity)pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
                this.model.setupAnim(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
                VertexConsumer ivertexbuilder = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)BLINKING));
                this.blinkEyes(pLivingEntity);
                this.model.renderToBuffer(pMatrixStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)pLivingEntity, (float)0.0f));
            }
        }

        private void blinkEyes(ShubNiggurathSpawnEntity shub) {
            ModelPart[] eyes = new ModelPart[]{this.model.eye1, this.model.eye2, this.model.eye3, this.model.eye4};
            for (int i = 0; i < eyes.length; ++i) {
                eyes[i].visible = shub.isBlinking(i);
            }
        }
    }
}

