/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.FairyFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.FairyFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class FairyFamiliarRenderer
extends MobRenderer<FairyFamiliarEntity, FairyFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/fairy_familiar.png");

    public FairyFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new FairyFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_FAIRY)), 0.3f);
        this.addLayer(new SleepLayer((RenderLayerParent<FairyFamiliarEntity, FairyFamiliarModel>)this));
    }

    public void render(FairyFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.0f, pEntity.getAnimationHeight(pPartialTicks), 0.0f);
        this.performMagicTransform(pEntity, pEntityYaw, pPartialTicks, pMatrixStack);
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.popPose();
    }

    private void performMagicTransform(FairyFamiliarEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn) {
        Entity target = entityIn.getMagicTarget();
        if (target != null) {
            Vec3 pos = entityIn.getMagicPosition(partialTicks).subtract(entityIn.getPosition(partialTicks));
            Vec2 radiusAngle = entityIn.getMagicRadiusAngle(partialTicks);
            matrixStackIn.translate(pos.x, pos.y, pos.z);
            matrixStackIn.mulPose(new Quaternionf().rotateXYZ(0.0f, -radiusAngle.y * ((float)Math.PI / 180), 0.0f));
            this.shadowStrength = 0.0f;
        } else {
            this.shadowStrength = 1.0f;
        }
    }

    public ResourceLocation getTextureLocation(FairyFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class SleepLayer
    extends RenderLayer<FairyFamiliarEntity, FairyFamiliarModel> {
        private static final ResourceLocation SLEEP = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/fairy_familiar_sleep.png");

        public SleepLayer(RenderLayerParent<FairyFamiliarEntity, FairyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, FairyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isInvisible() || !pLivingEntity.isSitting() || pLivingEntity.isPartying()) {
                return;
            }
            FairyFamiliarModel model = (FairyFamiliarModel)this.getParentModel();
            VertexConsumer ivertexbuilder = pBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)SLEEP));
            model.renderToBuffer(pMatrixStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)pLivingEntity, (float)0.0f));
        }
    }
}

