/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.api.common.data;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum SortType implements StringRepresentable
{
    AMOUNT,
    NAME,
    MOD;

    private static final Map<String, SortType> TYPES;
    public static final Codec<SortType> CODEC;
    public static final IntFunction<SortType> BY_ID;
    public static final StreamCodec<ByteBuf, SortType> STREAM_CODEC;

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public SortType next() {
        return SortType.values()[(this.ordinal() + 1) % SortType.values().length];
    }

    static {
        TYPES = new Object2ObjectArrayMap();
        CODEC = Codec.stringResolver(SortType::getSerializedName, TYPES::get);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])SortType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        for (SortType type : SortType.values()) {
            TYPES.put(type.getSerializedName(), type);
        }
    }
}

