/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.network;

import alexthw.not_enough_glyphs.common.spellbinder.SpellBinder;
import alexthw.not_enough_glyphs.init.NotEnoughGlyphs;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PacketSetBinderSlot
extends AbstractPacket {
    public int slot;
    public static final CustomPacketPayload.Type<PacketSetBinderSlot> TYPE = new CustomPacketPayload.Type(NotEnoughGlyphs.prefix("set_binder_mode"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetBinderSlot> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, s -> s.slot, PacketSetBinderSlot::new);

    public PacketSetBinderSlot(int slot) {
        this.slot = slot;
    }

    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        AbstractCaster<?> caster;
        if (player == null) {
            return;
        }
        InteractionHand bookHand = SpellBinder.getBookHand((Player)player);
        if (bookHand == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(bookHand);
        if (stack.getItem() instanceof SpellBinder && (caster = SpellBinder.getBinderCaster(stack)) != null) {
            caster.setCurrentSlot(this.slot).saveToStack(stack);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

