/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.propagators;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.glyphs.forms.MethodOverhead;
import com.alexthw.sauce.api.IPropagator;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class PropagateOverhead
extends AbstractEffect
implements IPropagator {
    public static final PropagateOverhead INSTANCE = new PropagateOverhead();

    public PropagateOverhead() {
        super(CompatRL.omega("propagate_overhead"), "Propagate Overhead");
    }

    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public String getBookDescription() {
        return "Takes the remainder of the spell and cast it above the target.";
    }

    public void propagate(Level world, HitResult result, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            resolver.onResolveEffect(world, (HitResult)new BlockHitResult(entityHitResult.getEntity().getEyePosition(), Direction.DOWN, entityHitResult.getEntity().blockPosition().above(2), true));
        } else if (result instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            resolver.onResolveEffect(world, (HitResult)new BlockHitResult(blockHitResult.getLocation(), blockHitResult.getDirection(), blockHitResult.getBlockPos().above(), blockHitResult.isInside()));
        }
    }

    public Integer getTypeIndex() {
        return 8;
    }

    public int getDefaultManaCost() {
        return 100;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return MethodOverhead.INSTANCE.getCompatibleAugments();
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "Not Enough Glyphs";
                }
            };
        }
        return this.glyphItem;
    }
}

