/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.effects;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class EffectReverseDirection
extends AbstractEffect {
    public static final EffectReverseDirection INSTANCE = new EffectReverseDirection("reverse_direction", "Reverse Direction");

    public EffectReverseDirection(String tag, String description) {
        super(CompatRL.tmg(tag), description);
    }

    public String getBookDescription() {
        return "Reverses the direction of the spell, making it resolve as it was cast from the opposite side of the block. Especially useful with block-placing spells, as reversing the direction of pierce will point towards the caster instead of away.";
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockHitResult reversedRayTraceResult = rayTraceResult.withPosition(rayTraceResult.isInside() ? rayTraceResult.getBlockPos() : rayTraceResult.getBlockPos().relative(rayTraceResult.getDirection()).relative(rayTraceResult.getDirection())).withDirection(rayTraceResult.getDirection().getOpposite());
        spellContext.setCanceled(true);
        if (spellContext.getCurrentIndex() >= spellContext.getSpell().size()) {
            return;
        }
        Spell continuation = spellContext.getRemainingSpell();
        SpellContext newContext = spellContext.clone().withSpell(continuation);
        resolver.getNewResolver(newContext).onResolveEffect(world, (HitResult)reversedRayTraceResult);
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }

    public int getDefaultManaCost() {
        return 0;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return Collections.emptySet();
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "Not Enough Glyphs";
                }
            };
        }
        return this.glyphItem;
    }
}

