/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.effects;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectResize
extends AbstractEffect
implements IPotionEffect {
    public static final EffectResize INSTANCE = new EffectResize();

    public EffectResize() {
        super(CompatRL.scalaes("resize"), "Resize");
    }

    public String getName() {
        return "Resize";
    }

    public String getBookDescription() {
        return "Resizes the target entity for a short time or resets to original size if not augmented. Use Amplify to grow and Dampen to shrink.";
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAmplify.INSTANCE, "Enlarge the target.");
        map.put((AbstractAugment)AugmentDampen.INSTANCE, "Shrink the target.");
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity living;
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getAttribute(Attributes.SCALE) != null) {
            if (spellStats.getAmpMultiplier() == 0.0) {
                living.removeEffect(Registry.GROWING_EFFECT);
                living.removeEffect(Registry.SHRINKING_EFFECT);
            } else {
                this.applyConfigPotion(living, (Holder<MobEffect>)(spellStats.getAmpMultiplier() > 0.0 ? Registry.GROWING_EFFECT : Registry.SHRINKING_EFFECT), spellStats, false);
            }
        }
    }

    public void applyConfigPotion(LivingEntity entity, Holder<MobEffect> potionEffect, SpellStats spellStats, boolean particles) {
        this.applyPotion(entity, potionEffect, spellStats, this.getBaseDuration(), spellStats.getDurationMultiplier() >= 0.0 ? this.getExtendTimeDuration() : this.getDurationDown(), particles);
    }

    public void applyPotion(LivingEntity entity, Holder<MobEffect> potionEffect, SpellStats stats, int baseDurationSeconds, int durationBuffSeconds, boolean showParticles) {
        if (entity == null) {
            return;
        }
        int ticks = baseDurationSeconds * 20 + durationBuffSeconds * stats.getDurationInTicks();
        int amp = (int)Math.abs(stats.getAmpMultiplier());
        entity.forceAddEffect(new MobEffectInstance(potionEffect, ticks, amp, false, showParticles, false), (Entity)entity);
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 1200);
        this.addExtendTimeConfig(builder, 2400);
        this.addDurationDownConfig(builder, 400);
    }

    protected int getDefaultManaCost() {
        return 100;
    }

    public Glyph getGlyph() {
        if (this.glyphItem == null) {
            this.glyphItem = new Glyph(this, (AbstractSpellPart)this){

                @NotNull
                public String getCreatorModId(@NotNull ItemStack itemStack) {
                    return "Not Enough Glyphs";
                }
            };
        }
        return this.glyphItem;
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE});
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 60 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 120 : (Integer)this.EXTEND_TIME.get();
    }

    public int getDurationDown() {
        return this.DURATION_DOWN_TIME == null ? 30 : (Integer)this.DURATION_DOWN_TIME.get();
    }
}

