/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.api;

import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ContingencyEffectInstance
extends MobEffectInstance {
    protected final TRIGGER trigger;
    SpellResolver spell;
    double amplifier;
    int activations;
    int max_activations;

    public ContingencyEffectInstance(SpellResolver spell, TRIGGER trigger, int duration, double amplifier, int max_activations) {
        super(Registry.CONTINGENCY, duration, 0, false, false);
        this.spell = spell;
        this.trigger = trigger;
        this.amplifier = amplifier;
        this.activations = 0;
        this.max_activations = max_activations;
    }

    public TRIGGER getTrigger() {
        return this.trigger;
    }

    public void triggerSpell(LivingEntity entity) {
        if (this.activations <= this.max_activations) {
            this.spell.onResolveEffect(entity.level(), (HitResult)new EntityHitResult((Entity)entity));
            ++this.activations;
            if (this.activations >= this.max_activations) {
                entity.removeEffect(Registry.CONTINGENCY);
            }
        }
    }

    public void onMobHurt(@NotNull LivingEntity livingEntity, @NotNull DamageSource damageSource, float amount) {
        if (this.trigger == TRIGGER.HEROICS && (double)livingEntity.getHealth() <= (double)livingEntity.getMaxHealth() * (2.0 + this.amplifier) / 10.0 || this.trigger == TRIGGER.ON_FIRE && damageSource.is(DamageTypeTags.IS_FIRE)) {
            this.triggerSpell(livingEntity);
        }
    }

    public boolean update(@NotNull MobEffectInstance other) {
        return true;
    }

    public boolean tick(@NotNull LivingEntity entity, @NotNull Runnable onExpirationRunnable) {
        if (entity.level().isClientSide) {
            return super.tick(entity, onExpirationRunnable);
        }
        if (this.trigger == TRIGGER.ON_FALL && (double)entity.fallDistance > 5.0 + this.amplifier) {
            this.triggerSpell(entity);
        }
        Runnable newExpirationRunnable = () -> {
            if (this.trigger == TRIGGER.EXPIRE) {
                this.triggerSpell(entity);
            } else {
                onExpirationRunnable.run();
            }
        };
        return super.tick(entity, newExpirationRunnable);
    }

    public static enum TRIGGER {
        ON_FALL,
        ON_FIRE,
        ON_HEAL,
        HEROICS,
        BLINK,
        DEATH,
        EXPIRE;

    }
}

