/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import commoble.morered.MoreRed;
import commoble.morered.wires.AbstractWireBlock;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.Nullable;

public class VoxelCache {
    public static VoxelShape get(Level level, BlockPos pos) {
        int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        ChunkAccess chunk = level.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
        if (chunk == null) {
            return Shapes.empty();
        }
        Map map = (Map)chunk.getData((AttachmentType)MoreRed.get().voxelCacheAttachment.get());
        @Nullable VoxelShape cachedShape = (VoxelShape)map.get(pos);
        if (cachedShape != null) {
            return cachedShape;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof AbstractWireBlock)) {
            return Shapes.empty();
        }
        AbstractWireBlock wireBlock = (AbstractWireBlock)block;
        VoxelShape wireShape = wireBlock.getCachedExpandedShapeVoxel(state, level, pos);
        map.put(pos.immutable(), wireShape);
        return wireShape;
    }

    public static void invalidate(Level level, BlockPos pos) {
        int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        ChunkAccess chunk = level.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
        if (chunk == null) {
            return;
        }
        Map map = (Map)chunk.getData((AttachmentType)MoreRed.get().voxelCacheAttachment.get());
        map.remove(pos);
    }
}

