/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import com.mojang.math.OctahedralGroup;
import commoble.morered.MoreRed;
import commoble.morered.util.EightGroup;
import commoble.morered.wire_post.SyncPostsInChunkPacket;
import commoble.morered.wire_post.WirePostBlockEntity;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractPostBlock
extends Block {
    public static final DirectionProperty DIRECTION_OF_ATTACHMENT = BlockStateProperties.FACING;
    public static final EnumProperty<OctahedralGroup> TRANSFORM = EightGroup.TRANSFORM;

    public AbstractPostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIRECTION_OF_ATTACHMENT, (Comparable)Direction.DOWN)).setValue(TRANSFORM, (Comparable)OctahedralGroup.IDENTITY));
    }

    protected abstract void notifyNeighbors(Level var1, BlockPos var2, BlockState var3);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DIRECTION_OF_ATTACHMENT, TRANSFORM});
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.hasCollision ? state.getShape(worldIn, pos, context) : Shapes.empty();
    }

    @Deprecated
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updatePostSet(world, pos, Set::add);
        super.onPlace(state, world, pos, oldState, isMoving);
        this.notifyNeighbors(world, pos, state);
    }

    @Deprecated
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof WirePostBlockEntity) {
                WirePostBlockEntity be = (WirePostBlockEntity)blockEntity;
                be.clearRemoteConnections();
            }
            this.updatePostSet(level, pos, Set::remove);
            level.removeBlockEntity(pos);
            this.notifyNeighbors(level, pos, state);
        }
    }

    public void updatePostSet(Level world, BlockPos pos, BiConsumer<Set<BlockPos>, BlockPos> consumer) {
        LevelChunk chunk = world.getChunkAt(pos);
        if (chunk != null) {
            Set set = (Set)chunk.getData((AttachmentType)MoreRed.get().postsInChunkAttachment.get());
            consumer.accept(set, pos);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                chunk.setUnsaved(true);
                ChunkPos chunkPos = chunk.getPos();
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunkPos, (CustomPacketPayload)new SyncPostsInChunkPacket(chunkPos, set), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState defaultState = this.defaultBlockState();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState checkState = (BlockState)defaultState.setValue((Property)DIRECTION_OF_ATTACHMENT, (Comparable)direction);
            if (checkState == null || !checkState.canSurvive((LevelReader)world, pos)) continue;
            return world.isUnobstructed(checkState, pos, CollisionContext.empty()) ? checkState : null;
        }
        return null;
    }

    @Deprecated
    public BlockState rotate(BlockState state, Rotation rot) {
        BlockState newState = (BlockState)state.setValue((Property)DIRECTION_OF_ATTACHMENT, (Comparable)rot.rotate((Direction)state.getValue((Property)DIRECTION_OF_ATTACHMENT)));
        newState = EightGroup.rotate(newState, rot);
        return newState;
    }

    @Deprecated
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        Direction oldFacing = (Direction)state.getValue((Property)DIRECTION_OF_ATTACHMENT);
        Direction newFacing = mirrorIn.getRotation(oldFacing).rotate(oldFacing);
        BlockState newState = (BlockState)state.setValue((Property)DIRECTION_OF_ATTACHMENT, (Comparable)newFacing);
        newState = EightGroup.mirror(newState, mirrorIn);
        return newState;
    }
}

