/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client.emi;

import commoble.morered.client.emi.EmiProxy;
import commoble.morered.soldering.SolderingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public record SolderingEmiRecipe(ResourceLocation id, List<EmiIngredient> inputs, List<EmiStack> outputs) implements EmiRecipe
{
    public static SolderingEmiRecipe create(RecipeHolder<SolderingRecipe> recipe) {
        return new SolderingEmiRecipe(recipe.id(), ((SolderingRecipe)recipe.value()).ingredients().stream().map(sizedIngredient -> EmiIngredient.of((Ingredient)sizedIngredient.ingredient(), (long)sizedIngredient.count())).toList(), List.of(EmiStack.of((ItemStack)((SolderingRecipe)recipe.value()).result())));
    }

    public EmiRecipeCategory getCategory() {
        return EmiProxy.SOLDERING_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 118;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 18);
        widgets.addTexture(EmiTexture.SHAPELESS, 97, 0);
        int inputCount = this.inputs.size();
        for (int i = 0; i < 9; ++i) {
            int row = i / 3;
            int column = i % 3;
            int inputX = column * 18;
            int inputY = row * 18;
            EmiStack input = i < inputCount ? this.inputs.get(i) : EmiStack.of((ItemStack)ItemStack.EMPTY);
            widgets.addSlot((EmiIngredient)input, inputX, inputY);
        }
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 92, 14).large(true).recipeContext((EmiRecipe)this);
    }
}

