/*
 * Decompiled with CFR 0.152.
 */
package dev.dvoa.moresounds.utils.helpers;

import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class MoreResourceHelper {
    public static Map<String, String> fromID(String id) {
        String[] p = id.split(":");
        return Map.of("namespace", p[0], "path", p[1]);
    }

    public static class Location {
        public static ResourceLocation getResource(Map<String, String> id) {
            return ResourceLocation.fromNamespaceAndPath((String)id.get("namespace"), (String)id.get("path"));
        }

        public static ResourceLocation getResource(String id) {
            return Location.getResource(MoreResourceHelper.fromID(id));
        }

        public static ResourceLocation getResource(String namespace, String path) {
            return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
        }
    }

    public static class Keys {

        public static class Blocks {
            public static ResourceKey<Block> getResourceByID(ResourceLocation resourceLocation) {
                return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation);
            }

            public static ResourceKey<Block> getResourceByID(String namespace, String path) {
                return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
            }

            public static ResourceKey<Block> getResourceByID(String id) {
                return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Location.getResource(id));
            }
        }

        public static class Items {
            public static ResourceKey<Item> getResourceByID(ResourceLocation resourceLocation) {
                return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
            }

            public static ResourceKey<Item> getResourceByID(String namespace, String path) {
                return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
            }

            public static ResourceKey<Item> getResourceByID(String id) {
                return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Location.getResource(id));
            }
        }
    }
}

