/*
 * Decompiled with CFR 0.152.
 */
package dev.dvoa.moresounds.datagen.providers;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dvoa.moresounds.datagen.codecs.SoundAction;
import dev.dvoa.moresounds.utils.SoundActionHolder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.NotNull;

public class MoreSoundActionProvider
implements DataProvider {
    private static final String NAMESPACE = "minecraft";
    private final PackOutput output;
    private final List<SoundActionHolder> entries;

    public MoreSoundActionProvider(PackOutput output, List<SoundActionHolder> entries) {
        this.output = output;
        this.entries = entries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path base = this.output.getOutputFolder();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (SoundActionHolder action : this.entries) {
            Path soundsDir = base.resolve("assets/minecraft/sounds/" + action.getSoundType());
            Path file = soundsDir.resolve(action.getFileName() + ".json");
            JsonElement json = (JsonElement)SoundAction.CODEC.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)action.getSoundAction()).getOrThrow();
            CompletableFuture fut = DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)file);
            futures.add(fut);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @NotNull
    public String getName() {
        return "SoundActionProvider[assets/minecraft/sounds]";
    }
}

