/*
 * Decompiled with CFR 0.152.
 */
package dev.dvoa.moresounds.datagen.providers;

import dev.dvoa.moresounds.utils.helpers.MorePatternHelper;
import dev.dvoa.moresounds.utils.helpers.MoreResourceHelper;
import dev.dvoa.moresounds.utils.tags.MoreTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class MoreItemTagsProvider
extends ItemTagsProvider {
    public MoreItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "more_sounds", existingFileHelper);
    }

    private void appendPattern(IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> appender, String pattern) {
        for (String path : MorePatternHelper.expand(pattern)) {
            appender.addOptional(MoreResourceHelper.Location.getResource(path));
        }
    }

    protected void addTags(@Nullable HolderLookup.Provider provider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender bipbip = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.BIPBIP).replace(false).addOptional(MoreResourceHelper.Location.getResource("mekanism:robit")).addOptional(MoreResourceHelper.Location.getResource("shrink:shrinking_device")).addOptional(MoreResourceHelper.Location.getResource("advancedperipherals:colony_integrator")).addOptional(MoreResourceHelper.Location.getResource("shrink:shrinking_device")).addOptional(MoreResourceHelper.Location.getResource("justdirethings:portalgun")).addOptional(MoreResourceHelper.Location.getResource("justdirethings:portalgun_v2")).addOptional(MoreResourceHelper.Location.getResource("computercraft:pocket_computer_advanced")).addOptional(MoreResourceHelper.Location.getResource("computercraft:pocket_computer_normal")).addOptionalTag(MoreTags.Items.COMPUTERS).addOptional(MoreResourceHelper.Location.getResource("mekanism:dosimeter")).addOptional(MoreResourceHelper.Location.getResource("mekanism:geiger_counter"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)bipbip, "buildinggadgets2:gadget_(building|copy_paste|cut_paste|destruction|exchanging)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)bipbip, "mekanism:(network|seismic)_reader");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)bipbip, "mekanism:mekasuit_(bodyarmor|boots|helmet|pants)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)bipbip, "mekanism:portable_(qio_dashboard|teleporter)");
        this.tag(MoreTags.Items.BOATS).addOptional(MoreResourceHelper.Location.getResource("sophisticatedstorageinmotion:storage_boat")).addOptionalTag(MoreTags.Items.MINECRAFT_BOATS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender bott_viscous = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.BOTTLED_VISCOUS).addOptional(MoreResourceHelper.Location.getResource("supplementaries:antique_ink")).addOptional(MoreResourceHelper.Location.getResource("occultism:purified_ink")).addOptional(MoreResourceHelper.Location.getResource("the_bumblezone:royal_jelly_bottle")).addOptional(MoreResourceHelper.Location.getResource("gag:pigment_jar")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:fiery_blood")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:fiery_tears")).addOptional(MoreResourceHelper.Location.getResource("relics:blazing_flask"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)bott_viscous, "irons_spellbooks:(common|epic|legendary|rare|uncommon)_ink");
        this.tag(MoreTags.Items.GENERIC_WRENCHES).addTag(Tags.Items.TOOLS_WRENCH).addOptionalTag(MoreTags.Items.WRENCHES).addOptional(MoreResourceHelper.Location.getResource("advancedperipherals:computer_tool")).remove(MoreResourceHelper.Location.getResource("pneumaticcraft:pneumatic_wrench")).remove(MoreResourceHelper.Location.getResource("ae2:nether_quartz_wrench")).remove(MoreResourceHelper.Location.getResource("ae2:certus_quartz_wrench"));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender glass = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.GLASS).addTag(Tags.Items.GLASS_BLOCKS).addTag(Tags.Items.GLASS_PANES).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:alchemists_crown")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:item_detector")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:jar_of_light")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:wixie_shards")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:spell_sensor")).addOptional(MoreResourceHelper.Location.getResource("ars_additions:xp_jar")).addOptional(MoreResourceHelper.Location.getResource("ars_additions:ender_source_jar")).addOptional(MoreResourceHelper.Location.getResource("relics:magic_mirror")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:sandstorm_in_a_bottle")).addOptional(MoreResourceHelper.Location.getResource("shrink:shrink_bottle")).addOptional(MoreResourceHelper.Location.getResource("create:nixie_tube")).addOptional(MoreResourceHelper.Location.getResource("create:stock_ticker")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:message_in_a_bottle"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "ars_nouveau:(mob|source)_jar");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "ars_nouveau:potion_(flask|flask_amplify|flask_extend_time)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "twilightforest:(glass|ice)_sword");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:(dark_ethereal|dark_ethereal_reverse|ethereal|ethereal_reverse|ghostly|glass|light|obsidian|redstone)_door");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:(glass_dark_ethereal|glass_dark_ethereal_reverse|glass_ethereal|glass_ethereal_reverse|glass_ghostly|glass_light|glass_redstone)_pane");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:(dark_ethereal|dark_ethereal_reverse|ethereal|ethereal_reverse|ghostly|glass|light|obsidian|redstone)_trapdoor");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:(obsidian|sandstone|stone)_glass");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:(glass|glass_dark)_ethereal");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:(glass_dark_ethereal|glass_ethereal)_reverse");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:glass_(ghostly|light|redstone|slab)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)glass, "glassential:(black_glass|blue_glass|brown_glass|cyan_glass|gray_glass|green_glass|light_blue_glass|light_gray_glass|lime_glass|magenta_glass|orange_glass|pink_glass|purple_glass|red_glass|tinted_glass|white_glass|yellow_glass)_(trapdoor|door)");
        this.tag(MoreTags.Items.INTERFERENCE).addOptional(MoreResourceHelper.Location.getResource("mekanism:pellet_antimatter")).addOptional(MoreResourceHelper.Location.getResource("mekanism_extras:alloy_spectrum")).addOptional(MoreResourceHelper.Location.getResource("mekanism_extras:enriched_spectrum")).addOptional(MoreResourceHelper.Location.getResource("modern_industrialization:singularity")).addOptional(MoreResourceHelper.Location.getResource("ae2:singularity")).addOptional(MoreResourceHelper.Location.getResource("advanced_ae:shattered_singularity")).addOptional(MoreResourceHelper.Location.getResource("ae2:quantum_entangled_singularity"));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender papers = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.PAPERS).addOptionalTag(MoreTags.Items.COMMON_PAPERS).addOptionalTag(MoreTags.Items.SPELLBOOK).add(MoreResourceHelper.Keys.Items.getResourceByID("minecraft:filled_map")).add(MoreResourceHelper.Keys.Items.getResourceByID("minecraft:map")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:scroll")).addOptional(MoreResourceHelper.Location.getResource("supplementaries:slice_map")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:ore_map")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:magic_map")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:maze_map")).addOptional(MoreResourceHelper.Location.getResource("buildinggadgets2:template")).addOptional(MoreResourceHelper.Location.getResource("buildinggadgets2:redprint")).addOptional(MoreResourceHelper.Location.getResource("patchouli:guide_book")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:caster_tome")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:worn_notebook")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:annotated_codex")).addOptional(MoreResourceHelper.Location.getResource("ars_additions:imbued_spell_parchment")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:eldritch_manuscript"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "ars_nouveau:(allow|deny|mimic|scryer|stable_warp|warp)_scroll");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "ars_nouveau:(apprentice_spell|archmage_spell|creative_spell|novice_spell)_book");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "ars_additions:(exploration_warp|nexus_warp)_scroll");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "ars_additions:(ancient_codex|codex|lost_codex)_entry");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "ars_elemental:(air_caster|anima_caster|earth_caster|fire_caster|manipulation_caster|water_caster)_tome");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "twilightforest:(alpha_yeti_banner|hydra_banner|knight_phantom_banner|lich_banner|minoshroom_banner|naga_banner|quest_ram_banner|snow_queen_banner|ur_ghast_banner)_pattern");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "irons_spellbooks:furled_(map|map_ancient)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)papers, "apothic_enchanting:(boots|bow|chestplate|extraction|fishing|helmet|improved_scrap|leggings|other|pickaxe|scrap|weapon)_tome");
        this.tag(MoreTags.Items.METAL_PLATES).addOptionalTag(MoreTags.Items.COMMON_METAL_PLATES).remove(MoreResourceHelper.Location.getResource("create:cardboard")).addOptional(MoreResourceHelper.Location.getResource("create:brass_hand")).addOptional(MoreResourceHelper.Location.getResource("create:crafter_slot_cover")).addOptional(MoreResourceHelper.Location.getResource("create:filter")).addOptional(MoreResourceHelper.Location.getResource("create:minecart_coupling")).addOptional(MoreResourceHelper.Location.getResource("create:propeller")).addOptional(MoreResourceHelper.Location.getResource("create:whisk")).addOptional(MoreResourceHelper.Location.getResource("create:attribute_filter")).addOptional(MoreResourceHelper.Location.getResource("create:package_filter"));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender leather_things = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.LEATHER_THINGS).addOptional(MoreResourceHelper.Location.getResource("sophisticatedbackpacks:backpack")).addOptional(MoreResourceHelper.Location.getResource("ars_elemental:curio_bag")).addOptional(MoreResourceHelper.Location.getResource("ars_elemental:caster_bag")).addOptional(MoreResourceHelper.Location.getResource("minecraft:bundle")).addOptional(MoreResourceHelper.Location.getResource("ars_additions:handy_haversack")).addOptional(MoreResourceHelper.Location.getResource("actuallyadditions:void_sack")).addOptional(MoreResourceHelper.Location.getResource("actuallyadditions:travelers_sack")).addOptionalTag(MoreTags.Items.BACKPACK_UPGRADES).addOptionalTag(MoreTags.Items.STORAGE_UPGRADES).addOptionalTag(MoreTags.Items.MAGIC_ARMOR).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:belt_of_unstable_gifts")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:belt_of_levitation")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:mundane_belt")).addOptional(MoreResourceHelper.Location.getResource("artifacts:aqua_dashers")).addOptional(MoreResourceHelper.Location.getResource("artifacts:lucky_scarf")).addOptional(MoreResourceHelper.Location.getResource("artifacts:rooted_boots")).addOptional(MoreResourceHelper.Location.getResource("artifacts:scarf_of_invisibility")).addOptional(MoreResourceHelper.Location.getResource("artifacts:steadfast_spikes")).addOptional(MoreResourceHelper.Location.getResource("artifacts:strider_shoes")).addOptional(MoreResourceHelper.Location.getResource("artifacts:running_shoes")).addOptional(MoreResourceHelper.Location.getResource("artifacts:vampiric_glove")).addOptional(MoreResourceHelper.Location.getResource("artifacts:helium_flamingo")).addOptional(MoreResourceHelper.Location.getResource("relics:elytra_booster")).addOptional(MoreResourceHelper.Location.getResource("relics:enders_hand")).addOptional(MoreResourceHelper.Location.getResource("relics:midnight_robe")).addOptional(MoreResourceHelper.Location.getResource("relics:wool_mitten")).addOptional(MoreResourceHelper.Location.getResource("relics:rage_glove"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "sophisticatedbackpacks:(copper|diamond|gold|iron|netherite)_backpack");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "ars_elemental:(air|aqua|earth|fire)_(boots|hat|leggings|robes)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "twilightforest:(arctic|yeti)_(boots|chestplate|helmet|leggings)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "irons_spellbooks:(archevoker|cryomancer|cultist|electromancer|priest|pumpkin|pyromancer|shadowwalker|wandering_magician|plagued)_(chestplate|helmet|boots|leggings)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "artifacts:(anglers|cowboy)_hat");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "relics:(amphibian|springy)_boot");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "relics:(aqua|magma)_walker");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)leather_things, "relics:(hunter|leather)_belt");
        this.tag(MoreTags.Items.BOWS).addOptionalTag(Tags.Items.TOOLS_BOW).addOptionalTag(Tags.Items.TOOLS_CROSSBOW).addOptional(MoreResourceHelper.Location.getResource("cataclysm:cursed_bow")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:wrath_of_the_desert"));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender std_equip = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.STANDARD_EQUIP).addOptionalTag(Tags.Items.TOOLS_SPEAR).addOptionalTag(MoreTags.Items.JUST_HAMMERS).addOptionalTag(MoreTags.Items.RINGS).remove(MoreResourceHelper.Location.getResource("minecraft:trident")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:block_and_chain")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:knightmetal_shield")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:naga_leggings")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:phantom_helmet")).addOptional(MoreResourceHelper.Location.getResource("artifacts:fire_gauntlet")).addOptional(MoreResourceHelper.Location.getResource("artifacts:golden_hook")).addOptional(MoreResourceHelper.Location.getResource("artifacts:pickaxe_heater")).addOptional(MoreResourceHelper.Location.getResource("artifacts:power_glove")).addOptional(MoreResourceHelper.Location.getResource("artifacts:universal_attractor")).addOptional(MoreResourceHelper.Location.getResource("artifacts:superstitious_hat")).addOptional(MoreResourceHelper.Location.getResource("artifacts:onion_ring")).addOptional(MoreResourceHelper.Location.getResource("artifacts:warp_drive")).addOptional(MoreResourceHelper.Location.getResource("relics:drowned_belt")).addOptional(MoreResourceHelper.Location.getResource("relics:holy_locket")).addOptional(MoreResourceHelper.Location.getResource("relics:ice_breaker")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:amethyst_rapier")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:artificer_cane")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:autoloader_crossbow")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:decrepit_scythe")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:hellrazor")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:lightning_rod")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:magehunter")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:spellbreaker")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:athame")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:coral_bardiche")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:khopesh")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:soul_render")).addOptional(MoreResourceHelper.Location.getResource("cataclysm_spellbooks:spirit_sunderer")).addOptional(MoreResourceHelper.Location.getResource("create:goggles"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "mekanismtools:(bronze|lapis_lazuli|osmium|refined_glowstone|refined_obsidian|steel)_(axe|hoe|paxel|pickaxe|shield|shovel|sword|helmet|chestplate|leggings|boots)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "mekanismtools:(diamond|gold|iron|stone|wood)_paxel");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "deeperdarker:resonarium_(axe|boots|chestplate|helmet|hoe|leggings|pickaxe|shovel|sword)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "industrialforegoing:infinity_(backpack|drill|hammer|launcher|saw)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "ars_elemental:(air|anima|base|earth|fire|summon|water)_bangle");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "twilightforest:(fiery|ironwood|knightmetal|steeleaf)_(boots|chestplate|helmet|leggings|sword)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "twilightforest:(ironwood|steeleaf)_(hoe|shovel)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "twilightforest:(diamond_minotaur|gold_minotaur|ironwood|knightmetal|steeleaf)_axe");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "twilightforest:(fiery|ironwood|knightmetal|mazebreaker|steeleaf)_pickaxe");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "twilightforest:(naga|phantom)_chestplate");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "artifacts:(flame|shock|thorn)_pendant");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "artifacts:(digging|feral)_claws");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "artifacts:(cross|panic)_necklace");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "artifacts:charm_(of_shrinking|of_sinking)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "relics:(ice|roller)_skates");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "relics:(jellyfish|reflection)_necklace");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "irons_spellbooks:(blood|graybeard|ice|pyrium)_staff");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "irons_spellbooks:(keeper|legionnaire)_flamberge");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "cataclysm_spellbooks:(bloom_stone|coral|fake_wudjets|void)_staff");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "cataclysm:(ancient|coral)_spear");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "cataclysm:the_(annihilator|immolator)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "create:copper_(backtank|diving_boots|diving_helmet)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "aquaculture:(double|gold|heavy|iron|light|redstone)_hook");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)std_equip, "aquaculture:(gold_fishing|iron_fishing)_rod");
        IntrinsicHolderTagsProvider.IntrinsicTagAppender neth_equip = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.NETHERITE_EQUIP).addOptionalTag(MoreTags.Items.ADV_ARMOR).addOptionalTag(MoreTags.Items.ADV_TOOLS).addOptional(MoreResourceHelper.Location.getResource("cataclysm:blazing_grips")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:bulwark_of_the_flame")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:monstrous_helm")).addOptional(MoreResourceHelper.Location.getResource("cataclysm_spellbooks:abyssal_warlock_mask")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:ignitium_elytra_chestplate")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:netherite_mage_leggings")).addOptional(MoreResourceHelper.Location.getResource("artifacts:withered_bracelet")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:infernal_forge")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:the_incinerator")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:netherite_effigy"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "cataclysm:(cursium|ignitium)_(boots|chestplate|helmet|leggings)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "cataclysm_spellbooks:(abyssal_warlock|cursium_mage|ignis)_(boots|chestplate)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "cataclysm_spellbooks:(abyssal_warlock|ignis)_(helmet|leggings)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "cataclysm_spellbooks:cursium_(mage_circlet|mage_skirt)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "cataclysm_spellbooks:(cursium_mage|ignis_chestplate)_elytra");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "cataclysm:black_(steel_axe|steel_hoe|steel_pickaxe|steel_shovel|steel_sword|steel_targe)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "irons_spellbooks:(netherite_mage|paladin)_chestplate");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "irons_spellbooks:(netherite_mage|speed)_boots");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "irons_spellbooks:(netherite_mage|tarnished)_helmet");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)neth_equip, "create:netherite_(backtank|diving_boots|diving_helmet)");
        IntrinsicHolderTagsProvider.IntrinsicTagAppender skulk_equip = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.SCULK_EQUIP).addOptional(MoreResourceHelper.Location.getResource("deeperdarker:reinforced_echo_shard")).addOptional(MoreResourceHelper.Location.getResource("deeperdarker:warden_carapace")).addOptional(MoreResourceHelper.Location.getResource("deeperdarker:heart_of_the_deep"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)skulk_equip, "deeperdarker:warden_(axe|boots|chestplate|helmet|hoe|leggings|pickaxe|shovel|sword)");
        IntrinsicHolderTagsProvider.IntrinsicTagAppender cardboard = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.CARDBOARD).addOptional(MoreResourceHelper.Location.getResource("mekanism:cardboard_box")).addOptional(MoreResourceHelper.Location.getResource("create:cardboard"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)cardboard, "create:cardboard_package_(10x12|10x8|12x10|12x12)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)cardboard, "create:cardboard_(boots|chestplate|helmet|leggings|sword)");
        IntrinsicHolderTagsProvider.IntrinsicTagAppender magic_items = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.MAGIC_ITEMS).addOptional(MoreResourceHelper.Location.getResource("apotheosis:potion_charm")).addOptional(MoreResourceHelper.Location.getResource("apotheosis:gem_fused_slate")).addOptional(MoreResourceHelper.Location.getResource("gag:energized_hearthstone")).addOptional(MoreResourceHelper.Location.getResource("gag:hearthstone")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:charm_of_keeping_3")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:tower_key")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:divine_pearl")).addOptional(MoreResourceHelper.Location.getResource("artifacts:chorus_totem")).addOptional(MoreResourceHelper.Location.getResource("relics:phantom_boot")).addOptional(MoreResourceHelper.Location.getResource("relics:shadow_glaive")).addOptional(MoreResourceHelper.Location.getResource("relics:space_dissector")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:tidal_claws"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "ars_elemental:(firenando|siren)_charm");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "ars_additions:(dispel_protection|ender_mask|fall_prevention|fire_resistance|golden|night_vision|powdered_snow_walk|sonic_boom_protection|undying|void_protection|water_breathing|wither_protection)_charm");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "ars_nouveau:(alakarkinos|amethyst_golem|bookwyrm|drygmy|starbuncle|whirlisprig|wixie)_charm");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "apotheosis:sigil_of_(enhancement|rebirth|socketing|unnaming|withdrawal)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "twilightforest:(charm_of_keeping|charm_of_life)_(1|2)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "twilightforest:magic_(beans|map_focus)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "irons_spellbooks:(arcane|blood|cooldown|ender|evocation|fire|holy|ice|lightning|nature|protection)_rune");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "irons_spellbooks:(blood_upgrade|cooldown_upgrade|ender_upgrade|evocation_upgrade|fire_upgrade|holy_upgrade|ice_upgrade|lightning_upgrade|mana_upgrade|nature_upgrade|protection_upgrade|upgrade)_orb");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "cataclysm:void_(assault_shoulder_weapon|forge)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)magic_items, "cataclysm:gauntlet_(of_bulwark|of_guard|of_maelstrom)");
        this.tag(MoreTags.Items.FILLED_SACKS).addOptional(MoreResourceHelper.Location.getResource("gag:time_sand_pouch")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:transformation_powder")).addOptional(MoreResourceHelper.Location.getResource("relics:spore_sack")).addOptional(MoreResourceHelper.Location.getResource("gag:mining_dynamite")).addOptional(MoreResourceHelper.Location.getResource("gag:fishing_dynamite"));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender filled_bottles = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.FILLED_BOTTLES).addOptional(MoreResourceHelper.Location.getResource("the_bumblezone:sugar_water_bottle")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:brittle_potion_flask")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:greater_potion_flask")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:fire_ale")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:greater_healing_potion")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:lightning_bottle")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:netherward_tincture")).addOptional(MoreResourceHelper.Location.getResource("irons_spellbooks:timeless_slurry")).addOptional(MoreResourceHelper.Location.getResource("artifacts:antidote_vessel")).addOptional(MoreResourceHelper.Location.getResource("artifacts:cloud_in_a_bottle"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)filled_bottles, "irons_spellbooks:(evasion|greater_evasion|greater_invisibility|greater_oakskin|invisibility|oakskin)_elixir");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)filled_bottles, "artifacts:(novelty_drinking|plastic_drinking)_hat");
        IntrinsicHolderTagsProvider.IntrinsicTagAppender crystals = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.CRYSTALS).addOptional(MoreResourceHelper.Location.getResource("apotheosis:gem")).addOptionalTag(MoreTags.Items.AE2_WRENCHES).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:dull_trinket")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:magelight_torch")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:relay")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:scryers_oculus")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:source_gem")).addOptional(MoreResourceHelper.Location.getResource("ars_nouveau:starbuncle_shards")).addOptional(MoreResourceHelper.Location.getResource("ars_elemental:mark_of_mastery")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:carminite")).addOptional(MoreResourceHelper.Location.getResource("artifacts:crystal_heart")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:abyssal_sacrifice")).addOptional(MoreResourceHelper.Location.getResource("cataclysm_spellbooks:abyssal_upgrade_orb")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:amethyst_crab_shell")).addOptional(MoreResourceHelper.Location.getResource("ae2:charged_staff")).addOptional(MoreResourceHelper.Location.getResource("ae2:entropy_manipulator")).addOptional(MoreResourceHelper.Location.getResource("ae2:quartz_fixture")).addOptional(MoreResourceHelper.Location.getResource("ae2:small_quartz_bud")).addOptional(MoreResourceHelper.Location.getResource("create:experience_nugget")).addOptional(MoreResourceHelper.Location.getResource("create:rose_quartz")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:nether_star_hook")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:treasure_chest"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "apotheosis:(common|epic|mythic|rare|uncommon)_material");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:(amplify|pierce|split)_arrow");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:(abjuration|air|conjuration|earth|fire|manipulation|water)_essence");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:(basic_spell|rotating_spell|spell|timer_spell)_turret");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:(lingering_flask|splash_flask)_cannon");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:(shapers|summon)_focus");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:enchanters_(eye|fishing_rod|gauntlet|mirror|shield|sword)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:relay_(collector|deposit|splitter|warp)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:amulet_of_(mana_boost|mana_regen)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_elemental:(air|earth|fire|manipulation|water)_turret");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_elemental:(acceleration_prism|arc_prism|chaining_prism|deceleration_prism|homing_prism|piercing_prism)_lens");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_elemental:(air|earth|fire|lesser_air|lesser_earth|lesser_fire|lesser_water|necrotic|water)_focus");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "reliquified_twilight_forest:(absorption|frost|necromancy|shielding|twilight)_gem");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "cataclysm:(amethyst_crab|blessed_amethyst_crab)_meat");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "cataclysm:crystallized_(coral|coral_fragments)");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ae2:(certus_quartz|fluix|nether_quartz)_axe");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ae2:(certus_quartz|charged_certus_quartz|fluix)_crystal");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ae2:(certus_quartz|fluix|nether_quartz)_sword");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ae2:(certus_quartz|fluix|nether_quartz)_pickaxe");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ae2:(certus_quartz|fluix|nether_quartz)_hoe");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ae2:(certus_quartz_cutting|nether_quartz_cutting)_knife");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ae2:(certus_quartz|fluix|nether_quartz)_shovel");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "ars_nouveau:(experience|greater_experience)_gem");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)crystals, "aquaculture:neptunium_(ingot|nugget)");
        this.tag(MoreTags.Items.DUSTS).addOptionalTag(Tags.Items.DUSTS).addOptionalTag(MoreTags.Items.DIRTY_DUSTS).addOptional(MoreResourceHelper.Location.getResource("gag:sacred_salt")).addOptional(MoreResourceHelper.Location.getResource("apotheosis:gem_dust")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:armor_shard_cluster")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:borer_essence")).addOptional(MoreResourceHelper.Location.getResource("twilightforest:exanimate_essence")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:burning_ashes")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:dying_ember")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:koboleton_bone"));
        this.tag(MoreTags.Items.FOOD).addOptionalTag(Tags.Items.FOODS_RAW_FISH).addOptionalTag(Tags.Items.FOODS_COOKED_FISH).addOptionalTag(Tags.Items.FOODS_RAW_MEAT).addOptionalTag(Tags.Items.FOODS_COOKED_MEAT).addOptional(MoreResourceHelper.Location.getResource("artifacts:everlasting_beef")).addOptional(MoreResourceHelper.Location.getResource("artifacts:eternal_steak")).addOptional(MoreResourceHelper.Location.getResource("relics:infinity_ham"));
        this.tag(MoreTags.Items.WET).addOptional(MoreResourceHelper.Location.getResource("gag:sacred_salve")).addOptional(MoreResourceHelper.Location.getResource("gag:sacred_balm")).addOptional(MoreResourceHelper.Location.getResource("cataclysm:sticky_gloves")).addOptional(MoreResourceHelper.Location.getResource("create:sticker")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:algae")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:fish_fillet_raw")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:jellyfish")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:leech")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:sushi")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:worm"));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender diam_equip = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.DIAM_EQUIP).addOptional(MoreResourceHelper.Location.getResource("aquaculture:diamond_fishing_rod")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:diamond_hook"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)diam_equip, "aquaculture:neptunium_(axe|boots|chestplate|fillet_knife|helmet|hoe|leggings|pickaxe|shovel|sword|fishing_rod)");
        IntrinsicHolderTagsProvider.IntrinsicTagAppender wooden = (IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag(MoreTags.Items.WOOD_STUFF).addOptional(MoreResourceHelper.Location.getResource("aquaculture:box")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:driftwood")).addOptional(MoreResourceHelper.Location.getResource("aquaculture:lockbox"));
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)wooden, "aquaculture:(acacia_fish|birch_fish|dark_oak_fish|jungle_fish|oak_fish|spruce_fish)_mount");
        IntrinsicHolderTagsProvider.IntrinsicTagAppender buckets = this.tag(MoreTags.Items.FILLED_BUCKETS);
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)buckets, "aquaculture:(arapaima|atlantic_cod|atlantic_halibut|atlantic_herring|bayad|blackfish|bluegill|boulti|brown_shrooma|brown_trout|capitaine|carp|catfish|gar|jellyfish|minnow|muskellunge|pacific_halibut|perch|pink_salmon|piranha|pollock|rainbow_trout|red_grouper|red_shrooma|smallmouth_bass|synodontis|tambaqui|tuna)_bucket");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)buckets, "cataclysm:(modern_remnant|netherite_ministrosity|the_baby_leviathan)_bucket");
        this.appendPattern((IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>)buckets, "mekanism:(brine|chlorine|ethene|heavy_water|hydrofluoric_acid|hydrogen|hydrogen_chloride|lithium|nutritional_paste|oxygen|sodium|steam|sulfur_dioxide|sulfur_trioxide|sulfuric_acid|superheated_sodium|uranium_hexafluoride|uranium_oxide)_bucket");
    }
}

