/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.pack;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.pack.ImageMerger;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class MergedDynamicClientResourcesProvider
implements PackResources,
SimplePackProvider {
    private final Set<DynamicResourcesProvider> providers = new HashSet<DynamicResourcesProvider>();
    private final List<PackResources> packResourcesStack = new ArrayList<PackResources>();
    private final PackLocationInfo locationInfo;
    private final Set<String> modNamespaces = new HashSet<String>();
    private PackMetadataSection metadata;
    private byte[] packIcon;

    public MergedDynamicClientResourcesProvider(PackLocationInfo info) {
        this.locationInfo = info;
    }

    public void add(DynamicResourcesProvider provider) {
        if (provider.getPackType() != PackType.CLIENT_RESOURCES) {
            throw new IllegalArgumentException("Tried to merge a pack provider of type " + String.valueOf(provider.getPackType()) + " to a merged provider of type " + String.valueOf(PackType.CLIENT_RESOURCES));
        }
        if (this.providers.add(provider)) {
            this.packResourcesStack.add(provider.getPackResources());
            this.packResourcesStack.sort(Comparator.comparing(PackResources::packId));
            this.modNamespaces.add(provider.getName().getNamespace());
        }
    }

    public void addLegacy(DynamicResourcePack dynPack) {
        this.packResourcesStack.add(dynPack);
        this.packResourcesStack.sort(Comparator.comparing(PackResources::packId));
        this.modNamespaces.add(dynPack.mainNamespace);
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        if (fileName.equals("pack.png") && this.packIcon != null) {
            return () -> new ByteArrayInputStream(this.packIcon);
        }
        for (PackResources packResources : this.packResourcesStack) {
            IoSupplier r = packResources.getRootResource(strings);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        PackResources packResources;
        IoSupplier ioSupplier;
        Iterator<PackResources> iterator = this.packResourcesStack.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((ioSupplier = (packResources = iterator.next()).getResource(packType, location)) == null);
        return ioSupplier;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        HashMap map = new HashMap();
        for (PackResources packResources : this.packResourcesStack) {
            Objects.requireNonNull(map);
            packResources.listResources(packType, namespace, path, map::putIfAbsent);
        }
        map.forEach(resourceOutput);
    }

    public Set<String> getNamespaces(PackType type) {
        HashSet<String> set = new HashSet<String>();
        for (PackResources packResources : this.packResourcesStack) {
            set.addAll(packResources.getNamespaces(type));
        }
        return set;
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) throws IOException {
        if (this.metadata == null) {
            this.metadata = new PackMetadataSection((Component)Component.translatable((String)"message.moonlight.merged_pack.description", (Object[])new Object[]{this.modNamespaces.size()}), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES), Optional.empty());
        }
        return (T)(serializer == PackMetadataSection.TYPE ? this.metadata : null);
    }

    public PackLocationInfo location() {
        return this.locationInfo;
    }

    public void close() {
        this.packResourcesStack.forEach(PackResources::close);
    }

    public int size() {
        return this.packResourcesStack.size();
    }

    private void checkInitialized() {
        if (this.packIcon == null) {
            this.packIcon = this.createIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createIcon() {
        block24: {
            ArrayList<NativeImage> icons = new ArrayList<NativeImage>();
            for (Object p2 : this.packResourcesStack) {
                IoSupplier icon = p2.getRootResource(new String[]{"pack.png"});
                if (icon != null) {
                    try (InputStream s = (InputStream)icon.get();){
                        icons.add(NativeImage.read((InputStream)s));
                    }
                    catch (Exception e) {
                        Moonlight.LOGGER.error("Failed to read pack icon from {}", (Object)p2.packId(), (Object)e);
                    }
                    continue;
                }
                Moonlight.LOGGER.warn("Pack {} has no icon", (Object)p2.packId());
            }
            try {
                Object p2;
                block23: {
                    NativeImage image = ImageMerger.mergeSquare(icons, ImageMerger.Mode.MIN_AREA_NO_UPSCALE, -16777216);
                    try {
                        p2 = image.asByteArray();
                        if (image == null) break block23;
                    }
                    catch (Throwable p2) {
                        try {
                            if (image != null) {
                                try {
                                    image.close();
                                }
                                catch (Throwable throwable) {
                                    p2.addSuppressed(throwable);
                                }
                            }
                            throw p2;
                        }
                        catch (Exception ignored) {
                            Moonlight.LOGGER.error("Failed to merge pack icons");
                            for (NativeImage i : icons) {
                                i.close();
                            }
                            break block24;
                        }
                    }
                    image.close();
                }
                return p2;
            }
            finally {
                for (NativeImage i : icons) {
                    i.close();
                }
            }
        }
        return null;
    }

    @Override
    public Pack createPack() {
        final MergedDynamicClientResourcesProvider resources = this;
        return Pack.readMetaAndCreate((PackLocationInfo)this.locationInfo, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo location) {
                MergedDynamicClientResourcesProvider.this.checkInitialized();
                return resources;
            }

            public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                return resources;
            }
        }, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false));
    }
}

