/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.BiPredicate;

public class BestAlternativeCodec<A, B extends A, C extends A>
implements Codec<A> {
    private final Codec<B> first;
    private final Codec<C> second;
    private final BiPredicate<B, C> chooseFirst;

    public BestAlternativeCodec(Codec<B> first, Codec<C> second, BiPredicate<B, C> chooseFirst) {
        this.first = first;
        this.second = second;
        this.chooseFirst = chooseFirst;
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        DataResult firstRead = this.first.decode(ops, input);
        DataResult secondRead = this.second.decode(ops, input);
        if (firstRead.isSuccess() && secondRead.isSuccess()) {
            Object c;
            Object b = ((Pair)firstRead.result().orElseThrow()).getFirst();
            if (this.chooseFirst.test(b, c = ((Pair)secondRead.result().orElseThrow()).getFirst())) {
                return firstRead.map(p -> Pair.of((Object)p.getFirst(), (Object)p.getSecond()));
            }
            return secondRead.map(p -> Pair.of((Object)p.getFirst(), (Object)p.getSecond()));
        }
        if (firstRead.isSuccess()) {
            return firstRead.map(p -> Pair.of((Object)p.getFirst(), (Object)p.getSecond()));
        }
        if (secondRead.isSuccess()) {
            return secondRead.map(p -> Pair.of((Object)p.getFirst(), (Object)p.getSecond()));
        }
        return DataResult.error(() -> "Failed to parse either. First: " + ((DataResult.Error)firstRead.error().orElseThrow()).message() + "; Second: " + ((DataResult.Error)secondRead.error().orElseThrow()).message());
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        try {
            A b = input;
            return this.first.encode(b, ops, prefix);
        }
        catch (Exception e) {
            A c = input;
            return this.second.encode(c, ops, prefix);
        }
    }
}

