/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public interface IOneUserInteractable {
    public void setCurrentUser(@Nullable UUID var1);

    @Nullable
    public UUID getCurrentUser();

    default public boolean canBeUsedBy(BlockPos myPos, Entity player) {
        if (!(player instanceof ServerPlayer)) {
            return this.isCloseEnoughToUse(player, myPos);
        }
        ServerPlayer sp = (ServerPlayer)player;
        this.validateClaimer(myPos, sp.serverLevel());
        UUID uuid = this.getCurrentUser();
        if (uuid == null) {
            return true;
        }
        return uuid.equals(player.getUUID());
    }

    private void validateClaimer(BlockPos myPos, ServerLevel level) {
        if (level == null) {
            this.setCurrentUser(null);
            return;
        }
        UUID uuid = this.getCurrentUser();
        if (uuid == null) {
            return;
        }
        Entity player = level.getEntity(uuid);
        if (player == null || !this.isCloseEnoughToUse(player, myPos)) {
            this.setCurrentUser(null);
        }
    }

    default public boolean isCloseEnoughToUse(Entity e, BlockPos myPos) {
        double maxDistance = 8.0;
        if (e instanceof Player) {
            Player p = (Player)e;
            return p.canInteractWithBlock(myPos, maxDistance);
        }
        double currentDist = new AABB(myPos).distanceToSqr(e.getEyePosition());
        return currentDist < maxDistance * maxDistance;
    }
}

