/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class FastCachedWriter {
    private final Set<Path> dirCache = ConcurrentHashMap.newKeySet();

    public void writeFast(Path filePath, byte[] bytes) throws IOException {
        Path normParent;
        Path parent = filePath.getParent();
        Path path = normParent = parent == null ? null : parent.toAbsolutePath().normalize();
        if (normParent != null && this.dirCache.add(normParent)) {
            Files.createDirectories(normParent, new FileAttribute[0]);
        }
        int attempts = 0;
        while (true) {
            try {
                Files.write(filePath, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                return;
            }
            catch (NoSuchFileException e) {
                if (normParent == null || ++attempts > 2) {
                    throw e;
                }
                Files.createDirectories(normParent, new FileAttribute[0]);
                this.dirCache.add(normParent);
                continue;
            }
            break;
        }
    }

    public void clear() {
        this.dirCache.clear();
    }
}

