/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.base.Suppliers;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class OptRegSupplier<A>
implements RegSupplier<A> {
    private final Supplier<A> supp = Suppliers.memoize(() -> reg.get(loc));
    private final Supplier<Holder<A>> holderSupplier = Suppliers.memoize(() -> reg.getHolder(loc).orElse(null));
    private final ResourceLocation id;
    private final ResourceKey<A> key;

    protected OptRegSupplier(Registry<A> reg, ResourceLocation loc) {
        this.id = loc;
        this.key = ResourceKey.create((ResourceKey)reg.key(), (ResourceLocation)loc);
    }

    public static <A> OptRegSupplier<A> of(ResourceLocation location, Registry<A> registry) {
        return new OptRegSupplier<A>(registry, location);
    }

    public static <A> OptRegSupplier<A> of(ResourceLocation location, ResourceKey<Registry<A>> registry) {
        Registry reg = (Registry)BuiltInRegistries.REGISTRY.getOrThrow(registry);
        return new OptRegSupplier<A>(reg, location);
    }

    public static <A> OptRegSupplier<A> wrap(A obj, ResourceKey<Registry<A>> registry) {
        Registry reg = (Registry)BuiltInRegistries.REGISTRY.getOrThrow(registry);
        return OptRegSupplier.wrap(obj, reg);
    }

    public static <A> OptRegSupplier<A> wrap(A obj, Registry<A> registry) {
        return OptRegSupplier.of(Utils.getID(obj), registry);
    }

    public Optional<Holder<A>> asOptionalHolder() {
        return Optional.empty();
    }

    @Override
    public boolean is(TagKey<A> tag) {
        Holder<A> h = this.getHolder();
        return h != null && h.is(tag);
    }

    public boolean isPresent() {
        return this.get() != null;
    }

    public void ifPresent(Consumer<A> consumer) {
        A a = this.get();
        if (a != null) {
            consumer.accept(a);
        }
    }

    @Override
    @Nullable
    public A get() {
        return this.supp.get();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    @Nullable
    public ResourceKey<A> getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public Holder<A> getHolder() {
        return this.holderSupplier.get();
    }
}

