/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class CountedItemStacks
extends Object2IntOpenCustomHashMap<ItemStack> {
    public CountedItemStacks() {
        super((Hash.Strategy)new ItemStackHashingStrategy());
    }

    public CountedItemStacks(IItemHandler handler) {
        super(handler.getSlots(), (Hash.Strategy)new ItemStackHashingStrategy());
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            this.put(stack, this.getOrDefault(stack, 0) + stack.getCount());
        }
    }

    private static class ItemStackHashingStrategy
    implements Hash.Strategy<ItemStack> {
        private ItemStackHashingStrategy() {
        }

        public int hashCode(ItemStack object) {
            return 31 * Item.getId((Item)object.getItem()) + object.getDamageValue();
        }

        public boolean equals(ItemStack o1, ItemStack o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getItem() == o2.getItem() && o1.getDamageValue() == o2.getDamageValue();
        }
    }
}

