/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network.messages;

import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ValidateModuleMessage(InteractionHand hand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ValidateModuleMessage> TYPE = new CustomPacketPayload.Type(MiscUtil.RL("validate_module"));
    public static final StreamCodec<FriendlyByteBuf, ValidateModuleMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(InteractionHand.class), ValidateModuleMessage::hand, ValidateModuleMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleData(ValidateModuleMessage message, IPayloadContext context) {
        ItemStack stack = context.player().getItemInHand(message.hand());
        Item item = stack.getItem();
        if (item instanceof ModuleItem) {
            ModuleItem moduleItem = (ModuleItem)item;
            item = context.player();
            if (item instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)item;
                moduleItem.doModuleValidation(stack, sp);
            }
        }
    }
}

